/**
 * Copyright IBM Corp. 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

import { __decorate } from 'tslib';
import { classMap } from 'lit/directives/class-map.js';
import { LitElement, html } from 'lit';
import { property } from 'lit/decorators.js';
import { prefix } from '../../globals/settings.js';
import styles from './file-uploader.scss.js';
import { carbonElement } from '../../globals/decorators/carbon-element.js';

/**
 * @license
 *
 * Copyright IBM Corp. 2019, 2023
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
/**
 * The shell UI for file uploader.
 *
 * @element cds-file-uploader
 * @slot label-title.
 * @slot lebel-description.
 */
let CDSFileUploader = class CDSFileUploader extends LitElement {
    constructor() {
        super(...arguments);
        /**
         * `true` if the file uploader should disabled.
         */
        this.disabled = false;
        /**
         * The description text.
         */
        this.labelDescription = '';
        /**
         * The label title.
         */
        this.labelTitle = '';
    }
    updated(changedProperties) {
        if (changedProperties.has('disabled')) {
            const { selectorUploaderItem } = this
                .constructor;
            const uploaderItem = this.querySelector(selectorUploaderItem);
            uploaderItem.disabled = this.disabled;
        }
    }
    render() {
        const { disabled, labelDescription, labelTitle } = this;
        const labelClasses = classMap({
            [`${prefix}--file--label`]: true,
            [`${prefix}--label-description--disabled`]: disabled,
        });
        const descriptionClasses = classMap({
            [`${prefix}--label-description`]: true,
            [`${prefix}--label-description--disabled`]: disabled,
        });
        return html `
      <p class="${labelClasses}">
        <slot name="label-title">${labelTitle}</slot>
      </p>
      <p class="${descriptionClasses}">
        <slot name="label-description">${labelDescription}</slot>
      </p>
      <slot name="drop-container"></slot>
      <div class="${prefix}--file-container">
        <slot></slot>
      </div>
    `;
    }
    /**
     * A selector that will return the `<input>` to enter starting date.
     */
    static get selectorUploaderItem() {
        return `${prefix}-file-uploader-button,${prefix}-file-uploader-drop-container`;
    }
};
CDSFileUploader.styles = styles;
__decorate([
    property({ type: Boolean, reflect: true })
], CDSFileUploader.prototype, "disabled", void 0);
__decorate([
    property({ attribute: 'label-description' })
], CDSFileUploader.prototype, "labelDescription", void 0);
__decorate([
    property({ attribute: 'label-title' })
], CDSFileUploader.prototype, "labelTitle", void 0);
CDSFileUploader = __decorate([
    carbonElement(`${prefix}-file-uploader`)
], CDSFileUploader);
var CDSFileUploader$1 = CDSFileUploader;

export { CDSFileUploader$1 as default };
//# sourceMappingURL=file-uploader.js.map
