/**
 * Copyright IBM Corp. 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

import { __decorate } from 'tslib';
import { LitElement, html } from 'lit';
import { property } from 'lit/decorators.js';
import { carbonElement } from '../../globals/decorators/carbon-element.js';
import { prefix } from '../../globals/settings.js';
import styles from './form-group.scss.js';

/**
 * @license
 *
 * Copyright IBM Corp. 2019, 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
/**
 * The shell UI for file uploader.
 *
 * @element cds-form-group
 * @slot label-title.
 * @slot lebel-description.
 */
let CDSFormGroup = class CDSFormGroup extends LitElement {
    constructor() {
        super(...arguments);
        /**
         * Specify whether the Form Group is invalid
         */
        this.invalid = false;
        /**
         * Specify whether the message should be displayed in the Form Group
         */
        this.message = false;
    }
    render() {
        const { invalid, legendId, legendText, message, messageText } = this;
        return html `
      <fieldset
        class="${prefix}--fieldset"
        ?data-invalid=${invalid}
        aria-labelledby="${legendId}">
        <legend class="${prefix}--label" id=${legendId}>${legendText}</legend>
        <slot></slot>
        ${message
            ? html `<div class="${prefix}--form__requirements">
              ${messageText}
            </div>`
            : null}
      </fieldset>
    `;
    }
};
CDSFormGroup.styles = styles;
__decorate([
    property({ type: Boolean, reflect: true })
], CDSFormGroup.prototype, "invalid", void 0);
__decorate([
    property({ attribute: 'legend-id' })
], CDSFormGroup.prototype, "legendId", void 0);
__decorate([
    property({ attribute: 'legend-text' })
], CDSFormGroup.prototype, "legendText", void 0);
__decorate([
    property({ type: Boolean, reflect: true })
], CDSFormGroup.prototype, "message", void 0);
__decorate([
    property({ type: String, attribute: 'message-text', reflect: true })
], CDSFormGroup.prototype, "messageText", void 0);
CDSFormGroup = __decorate([
    carbonElement(`${prefix}-form-group`)
], CDSFormGroup);
var CDSFormGroup$1 = CDSFormGroup;

export { CDSFormGroup$1 as default };
//# sourceMappingURL=form-group.js.map
