/**
 * Copyright IBM Corp. 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

import { __decorate } from 'tslib';
import { LitElement, html } from 'lit';
import { prefix } from '../../globals/settings.js';
import styles from './form-item.scss.js';
import { carbonElement } from '../../globals/decorators/carbon-element.js';

/**
 * @license
 *
 * Copyright IBM Corp. 2019, 2023
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
/**
 * Presentational element for form items
 *
 * @element cds-form-item
 */
let CDSFormItem = class CDSFormItem extends LitElement {
    render() {
        return html ` <slot></slot> `;
    }
};
CDSFormItem.styles = styles; // `styles` here is a `CSSResult` generated by custom Vite loader
CDSFormItem = __decorate([
    carbonElement(`${prefix}-form-item`)
], CDSFormItem);
var CDSFormItem$1 = CDSFormItem;

export { CDSFormItem$1 as default };
//# sourceMappingURL=form-item.js.map
