/**
 * @license
 *
 * Copyright IBM Corp. 2019, 2023
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import { LitElement } from 'lit';
import { ICON_INDICATOR_KIND } from './defs';
export { ICON_INDICATOR_KIND };
/**
 * Icon Indicator.
 *
 * @element cds-icon-indicator
 */
declare class CDSIconIndicator extends LitElement {
    /**
     * Icon indicator should be size 16 or 20
     */
    size: number;
    /**
     * Label next to the icon.
     */
    label: string;
    /**
     * Icon Indicator kind
     */
    kind: ICON_INDICATOR_KIND;
    render(): import("lit-html").TemplateResult<1>;
    static styles: any;
}
export default CDSIconIndicator;
