/**
 * Copyright IBM Corp. 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

import { __decorate } from 'tslib';
import { LitElement, html } from 'lit';
import { property } from 'lit/decorators.js';
import { carbonElement } from '../../globals/decorators/carbon-element.js';
import { prefix } from '../../globals/settings.js';
import styles from './layer.scss.js';

/**
 * @license
 *
 * Copyright IBM Corp. 2019, 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
/**
 * Basic layer
 *
 * @element cds-layer
 * @fires cds-use-layer
 *   The name of the custom event fired when the "use layer" action occurs.
 * @slot children - The elements contained within the component.
 */
let CDSLayer = class CDSLayer extends LitElement {
    constructor() {
        super(...arguments);
        /**
         * Specify the layer level and override any existing levels based on hierarchy
         */
        this.level = 0;
    }
    updated() {
        if (!this.layers) {
            this.layers = this.querySelectorAll(this.constructor.selectorLayer);
        }
        this.layers.forEach((item) => {
            item.setAttribute('level', ((this.level + 1) % 3).toString());
        });
        this.dispatchEvent(new CustomEvent(this.constructor.eventUseLayer, {
            bubbles: true,
            cancelable: true,
            composed: true,
            detail: {
                layer: this,
                level: this.level,
            },
        }));
    }
    render() {
        return html ` <slot></slot> `;
    }
    /**
     * A selector that selects a layer component.
     */
    static get selectorLayer() {
        return `${prefix}-layer`;
    }
    /**
     * A selector that selects a layer component.
     */
    static get eventUseLayer() {
        return `${prefix}-use-layer`;
    }
};
CDSLayer.styles = styles;
__decorate([
    property({ type: Number, reflect: true })
], CDSLayer.prototype, "level", void 0);
__decorate([
    property()
], CDSLayer.prototype, "layers", void 0);
CDSLayer = __decorate([
    carbonElement(`${prefix}-layer`)
], CDSLayer);
var CDSLayer$1 = CDSLayer;

export { CDSLayer$1 as default };
//# sourceMappingURL=layer.js.map
