/**
 * Copyright IBM Corp. 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

import { __decorate } from 'tslib';
import { classMap } from 'lit/directives/class-map.js';
import { html } from 'lit';
import { property } from 'lit/decorators.js';
import { prefix } from '../../globals/settings.js';
import CDSUnorderedList from './unordered-list.js';
import { carbonElement } from '../../globals/decorators/carbon-element.js';

/**
 * @license
 *
 * Copyright IBM Corp. 2019, 2023
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
/**
 * Ordered list.
 */
let CDSOrderedList = class CDSOrderedList extends CDSUnorderedList {
    constructor() {
        super(...arguments);
        /**
         * Specify whether the ordered list should use native list styles instead of
         * custom counter
         */
        this.native = false;
    }
    render() {
        const classes = classMap({
            [`${prefix}--list--ordered`]: !this.native,
            [`${prefix}--list--ordered--native`]: this.native,
            [`${prefix}--list--nested`]: this.getAttribute('slot') === 'nested',
            [`${prefix}--list--expressive`]: this.isExpressive,
        });
        return html `
      <ol class="${classes}">
        <slot></slot>
      </ol>
    `;
    }
};
__decorate([
    property({ type: Boolean, reflect: true })
], CDSOrderedList.prototype, "native", void 0);
CDSOrderedList = __decorate([
    carbonElement(`${prefix}-ordered-list`)
], CDSOrderedList);
var CDSOrderedList$1 = CDSOrderedList;

export { CDSOrderedList$1 as default };
//# sourceMappingURL=ordered-list.js.map
