/**
 * Copyright IBM Corp. 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

import { __decorate } from 'tslib';
import { classMap } from 'lit/directives/class-map.js';
import { LitElement, html } from 'lit';
import { property } from 'lit/decorators.js';
import { prefix } from '../../globals/settings.js';
import styles from './list.scss.js';
import { carbonElement } from '../../globals/decorators/carbon-element.js';

/**
 * @license
 *
 * Copyright IBM Corp. 2019, 2023
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
/**
 * Ordered list.
 */
let CDSUnorderedList = class CDSUnorderedList extends LitElement {
    constructor() {
        super(...arguments);
        /**
         * `true` if expressive theme enabled.
         */
        this.isExpressive = false;
    }
    connectedCallback() {
        // Uses attribute for lookup from child
        if (this.closest(this.constructor.selectorListItem)) {
            this.setAttribute('slot', 'nested');
        }
        else {
            this.removeAttribute('slot');
        }
        super.connectedCallback();
    }
    render() {
        const classes = classMap({
            [`${prefix}--list--unordered`]: true,
            [`${prefix}--list--nested`]: this.getAttribute('slot') === 'nested',
            [`${prefix}--list--expressive`]: this.isExpressive,
        });
        return html `
      <ul class="${classes}">
        <slot></slot>
      </ul>
    `;
    }
    /**
     * A selector that will return list item.
     */
    static get selectorListItem() {
        return `${prefix}-list-item`;
    }
};
CDSUnorderedList.styles = styles;
__decorate([
    property({ type: Boolean, reflect: true })
], CDSUnorderedList.prototype, "isExpressive", void 0);
CDSUnorderedList = __decorate([
    carbonElement(`${prefix}-unordered-list`)
], CDSUnorderedList);
var CDSUnorderedList$1 = CDSUnorderedList;

export { CDSUnorderedList$1 as default };
//# sourceMappingURL=unordered-list.js.map
