/**
 * Copyright IBM Corp. 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

import { __decorate } from 'tslib';
import { classMap } from 'lit/directives/class-map.js';
import { LitElement, html } from 'lit';
import { property } from 'lit/decorators.js';
import { prefix } from '../../globals/settings.js';
import { LOADING_TYPE } from './defs.js';
export { LOADING_TYPE } from './defs.js';
import getLoadingIcon from './loading-icon.js';
import styles from './loading.scss.js';
import { carbonElement } from '../../globals/decorators/carbon-element.js';

/**
 * @license
 *
 * Copyright IBM Corp. 2019, 2023
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
/**
 * Spinner indicating loading state.
 *
 * @element cds-loading
 */
let CDSLoading = class CDSLoading extends LitElement {
    constructor() {
        super(...arguments);
        /**
         * The assistive text for the spinner icon.
         */
        this.assistiveText = 'Loading';
        /**
         * Spinner type.
         */
        this.type = LOADING_TYPE.REGULAR;
        /**
         * `true` if overlay should be applied.
         */
        this.overlay = false;
        /**
         * `true` if spinner should stop.
         */
        this.inactive = false;
    }
    render() {
        const { inactive, assistiveText, type, overlay } = this;
        const innerClasses = classMap({
            [`${prefix}--loading`]: true,
            [`${prefix}--loading--stop`]: inactive,
            [`${prefix}--loading--small`]: type === LOADING_TYPE.SMALL,
        });
        const icon = getLoadingIcon({ assistiveText, type });
        return overlay ? html `<div class="${innerClasses}">${icon}</div>` : icon;
    }
};
CDSLoading.styles = styles; // `styles` here is a `CSSResult` generated by custom Vite loader
__decorate([
    property({ attribute: 'assistive-text' })
], CDSLoading.prototype, "assistiveText", void 0);
__decorate([
    property()
], CDSLoading.prototype, "type", void 0);
__decorate([
    property({ type: Boolean, reflect: true })
], CDSLoading.prototype, "overlay", void 0);
__decorate([
    property({ type: Boolean, reflect: true })
], CDSLoading.prototype, "inactive", void 0);
CDSLoading = __decorate([
    carbonElement(`${prefix}-loading`)
], CDSLoading);
var CDSLoading$1 = CDSLoading;

export { CDSLoading$1 as default };
//# sourceMappingURL=loading.js.map
