/**
 * Copyright IBM Corp. 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

import { __decorate } from 'tslib';
import { LitElement, html } from 'lit';
import { property } from 'lit/decorators.js';
import Close20 from '../../icons/close/20.js';
import { prefix } from '../../globals/settings.js';
import { ifDefined } from 'lit/directives/if-defined.js';
import FocusMixin from '../../globals/mixins/focus.js';
import styles from './modal.scss.js';
import { carbonElement } from '../../globals/decorators/carbon-element.js';

/**
 * @license
 *
 * Copyright IBM Corp. 2019, 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
/**
 * Modal close button.
 *
 * @element cds-modal-close-button
 * @csspart button The button.
 * @csspart close-icon The close icon.
 */
let CDSModalCloseButton = class CDSModalCloseButton extends FocusMixin(LitElement) {
    constructor() {
        super(...arguments);
        /**
         * Specify a label for the close button of the modal; defaults to close
         */
        this.closeButtonLabel = 'Close';
    }
    updated() {
        var _a;
        (_a = this.parentElement) === null || _a === void 0 ? void 0 : _a.setAttribute('close-button', '');
    }
    render() {
        const { closeButtonLabel } = this;
        return html `
      <button
        part="button"
        aria-label="${ifDefined(closeButtonLabel)}"
        class="${prefix}--modal-close"
        title="${ifDefined(closeButtonLabel)}">
        ${Close20({
            part: 'close-icon',
            class: `${prefix}--modal-close__icon`,
        })}
      </button>
    `;
    }
};
CDSModalCloseButton.shadowRootOptions = Object.assign(Object.assign({}, LitElement.shadowRootOptions), { delegatesFocus: true });
CDSModalCloseButton.styles = styles; // `styles` here is a `CSSResult` generated by custom WebPack loader
__decorate([
    property({ attribute: 'close-button-label' })
], CDSModalCloseButton.prototype, "closeButtonLabel", void 0);
CDSModalCloseButton = __decorate([
    carbonElement(`${prefix}-modal-close-button`)
], CDSModalCloseButton);
var CDSModalCloseButton$1 = CDSModalCloseButton;

export { CDSModalCloseButton$1 as default };
//# sourceMappingURL=modal-close-button.js.map
