/**
 * Copyright IBM Corp. 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

import { __decorate } from 'tslib';
import { prefix } from '../../globals/settings.js';
import CDSButton from '../button/button.js';
import buttonStyles from '../button/button.scss.js';
import styles from './modal.scss.js';
import { carbonElement } from '../../globals/decorators/carbon-element.js';

/**
 * @license
 *
 * Copyright IBM Corp. 2021, 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
/**
 * Modal footer button.
 *
 * @element cds-modal-footer-button
 */
let CDSModalFooterButton = class CDSModalFooterButton extends CDSButton {
};
CDSModalFooterButton.styles = [buttonStyles, styles]; // `styles` here is a `CSSResult` generated by custom Vite loader
CDSModalFooterButton = __decorate([
    carbonElement(`${prefix}-modal-footer-button`)
], CDSModalFooterButton);
var CDSModalFooterButton$1 = CDSModalFooterButton;

export { CDSModalFooterButton$1 as default };
//# sourceMappingURL=modal-footer-button.js.map
