/**
 * Copyright IBM Corp. 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

import { __decorate } from 'tslib';
import { LitElement, html } from 'lit';
import { property } from 'lit/decorators.js';
import { prefix } from '../../globals/settings.js';
import styles from './modal.scss.js';
import { carbonElement } from '../../globals/decorators/carbon-element.js';

/**
 * @license
 *
 * Copyright IBM Corp. 2019, 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
/**
 * Modal footer.
 *
 * @element cds-modal-footer
 */
let CDSModalFooter = class CDSModalFooter extends LitElement {
    constructor() {
        super(...arguments);
        /**
         * `true` if this modal footer has more than two buttons.
         */
        this.hasThreeButtons = false;
    }
    /**
     * Handles `slotchange` event.
     */
    _handleSlotChange(event) {
        const { selectorButtons } = this.constructor;
        this.hasThreeButtons =
            event.target
                .assignedNodes()
                .filter((node) => node.nodeType === Node.ELEMENT_NODE &&
                node.matches(selectorButtons)).length > 2;
        this.requestUpdate();
    }
    render() {
        return html ` <slot @slotchange="${this._handleSlotChange}"></slot> `;
    }
    /**
     * A selector that selects the child buttons.
     */
    static get selectorButtons() {
        return `${prefix}-button,${prefix}-modal-footer-button`;
    }
};
CDSModalFooter.styles = styles; // `styles` here is a `CSSResult` generated by custom Vite loader
__decorate([
    property({ type: Boolean, reflect: true, attribute: 'has-three-buttons' })
], CDSModalFooter.prototype, "hasThreeButtons", void 0);
CDSModalFooter = __decorate([
    carbonElement(`${prefix}-modal-footer`)
], CDSModalFooter);
var CDSModalFooter$1 = CDSModalFooter;

export { CDSModalFooter$1 as default };
//# sourceMappingURL=modal-footer.js.map
