/**
 * Copyright IBM Corp. 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

import { __decorate } from 'tslib';
import { LitElement, html } from 'lit';
import { prefix } from '../../globals/settings.js';
import styles from './modal.scss.js';
import { carbonElement } from '../../globals/decorators/carbon-element.js';

/**
 * @license
 *
 * Copyright IBM Corp. 2019, 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
/**
 * Modal header.
 *
 * @element cds-modal-header
 */
let CDSModalHeader = class CDSModalHeader extends LitElement {
    constructor() {
        super(...arguments);
        /**
         * `true` if there is an AI Label.
         */
        this._hasAILabel = false;
    }
    /**
     * Handles `slotchange` event.
     */
    _handleSlotChange({ target }) {
        const hasContent = target
            .assignedNodes()
            .filter((elem) => elem.matches !== undefined
            ? elem.matches(this.constructor.aiLabelItem) ||
                // remove reference to slug in v12
                elem.matches(this.constructor.slugItem)
            : false);
        if (hasContent.length > 0) {
            this._hasAILabel = Boolean(hasContent);
            hasContent[0].setAttribute('size', 'sm');
        }
        this.requestUpdate();
    }
    updated() {
        var _a, _b;
        if (this._hasAILabel) {
            (_a = this.parentElement) === null || _a === void 0 ? void 0 : _a.setAttribute('ai-label', '');
        }
        else {
            (_b = this.parentElement) === null || _b === void 0 ? void 0 : _b.removeAttribute('ai-label');
        }
    }
    render() {
        return html ` <slot></slot>
      <slot name="ai-label" @slotchange="${this._handleSlotChange}"></slot>
      <slot name="slug" @slotchange="${this._handleSlotChange}"></slot>`;
    }
    /**
     * A selector that will return the slug item.
     *
     * remove in v12
     */
    static get slugItem() {
        return `${prefix}-slug`;
    }
    /**
     * A selector that will return the AI Label item.
     */
    static get aiLabelItem() {
        return `${prefix}-ai-label`;
    }
};
CDSModalHeader.styles = styles; // `styles` here is a `CSSResult` generated by custom WebPack loader
CDSModalHeader = __decorate([
    carbonElement(`${prefix}-modal-header`)
], CDSModalHeader);
var CDSModalHeader$1 = CDSModalHeader;

export { CDSModalHeader$1 as default };
//# sourceMappingURL=modal-header.js.map
