/**
 * Copyright IBM Corp. 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

import { css } from 'lit';

var styles = css([".cds--layer-one,:root{--cds-layer:var(--cds-layer-01,#f4f4f4);--cds-layer-active:var(--cds-layer-active-01,#c6c6c6);--cds-layer-hover:var(--cds-layer-hover-01,#e8e8e8);--cds-layer-selected:var(--cds-layer-selected-01,#e0e0e0);--cds-layer-selected-hover:var(--cds-layer-selected-hover-01,#d1d1d1);--cds-layer-accent:var(--cds-layer-accent-01,#e0e0e0);--cds-layer-accent-hover:var(--cds-layer-accent-hover-01,#d1d1d1);--cds-layer-accent-active:var(--cds-layer-accent-active-01,#a8a8a8);--cds-field:var(--cds-field-01,#f4f4f4);--cds-field-hover:var(--cds-field-hover-01,#e8e8e8);--cds-border-subtle:var(--cds-border-subtle-00,#e0e0e0);--cds-border-subtle-selected:var(--cds-border-subtle-selected-01,#c6c6c6);--cds-border-strong:var(--cds-border-strong-01,#8d8d8d);--cds-border-tile:var(--cds-border-tile-01,#c6c6c6)}.cds--layer-two,:host(cds-modal-body){--cds-layer:var(--cds-layer-02,#fff);--cds-layer-active:var(--cds-layer-active-02,#c6c6c6);--cds-layer-hover:var(--cds-layer-hover-02,#e8e8e8);--cds-layer-selected:var(--cds-layer-selected-02,#e0e0e0);--cds-layer-selected-hover:var(--cds-layer-selected-hover-02,#d1d1d1);--cds-layer-accent:var(--cds-layer-accent-02,#e0e0e0);--cds-layer-accent-hover:var(--cds-layer-accent-hover-02,#d1d1d1);--cds-layer-accent-active:var(--cds-layer-accent-active-02,#a8a8a8);--cds-field:var(--cds-field-02,#fff);--cds-field-hover:var(--cds-field-hover-02,#e8e8e8);--cds-border-subtle:var(--cds-border-subtle-01,#c6c6c6);--cds-border-subtle-selected:var(--cds-border-subtle-selected-02,#c6c6c6);--cds-border-strong:var(--cds-border-strong-02,#8d8d8d);--cds-border-tile:var(--cds-border-tile-02,#a8a8a8)}.cds--layer-three{--cds-layer:var(--cds-layer-03,#f4f4f4);--cds-layer-active:var(--cds-layer-active-03,#c6c6c6);--cds-layer-hover:var(--cds-layer-hover-03,#e8e8e8);--cds-layer-selected:var(--cds-layer-selected-03,#e0e0e0);--cds-layer-selected-hover:var(--cds-layer-selected-hover-03,#d1d1d1);--cds-layer-accent:var(--cds-layer-accent-03,#e0e0e0);--cds-layer-accent-hover:var(--cds-layer-accent-hover-03,#d1d1d1);--cds-layer-accent-active:var(--cds-layer-accent-active-03,#a8a8a8);--cds-field:var(--cds-field-03,#f4f4f4);--cds-field-hover:var(--cds-field-hover-03,#e8e8e8);--cds-border-subtle:var(--cds-border-subtle-02,#e0e0e0);--cds-border-subtle-selected:var(--cds-border-subtle-selected-03,#c6c6c6);--cds-border-strong:var(--cds-border-strong-03,#8d8d8d);--cds-border-tile:var(--cds-border-tile-03,#c6c6c6)}.cds--layout--size-xs{--cds-layout-size-height-context:var(--cds-layout-size-height-xs,1.5rem);--cds-layout-size-height:var(--cds-layout-size-height-context)}.cds--layout-constraint--size__default-xs{--cds-layout-size-height:var(--cds-layout-size-height-context,var(--cds-layout-size-height-xs,1.5rem))}.cds--layout-constraint--size__min-xs{--cds-layout-size-height-min:var(--cds-layout-size-height-xs,1.5rem)}.cds--layout-constraint--size__max-xs{--cds-layout-size-height-max:var(--cds-layout-size-height-xs,1.5rem)}.cds--layout--size-sm{--cds-layout-size-height-context:var(--cds-layout-size-height-sm,2rem);--cds-layout-size-height:var(--cds-layout-size-height-context)}.cds--layout-constraint--size__default-sm{--cds-layout-size-height:var(--cds-layout-size-height-context,var(--cds-layout-size-height-sm,2rem))}.cds--layout-constraint--size__min-sm{--cds-layout-size-height-min:var(--cds-layout-size-height-sm,2rem)}.cds--layout-constraint--size__max-sm{--cds-layout-size-height-max:var(--cds-layout-size-height-sm,2rem)}.cds--layout--size-md{--cds-layout-size-height-context:var(--cds-layout-size-height-md,2.5rem);--cds-layout-size-height:var(--cds-layout-size-height-context)}.cds--layout-constraint--size__default-md{--cds-layout-size-height:var(--cds-layout-size-height-context,var(--cds-layout-size-height-md,2.5rem))}.cds--layout-constraint--size__min-md{--cds-layout-size-height-min:var(--cds-layout-size-height-md,2.5rem)}.cds--layout-constraint--size__max-md{--cds-layout-size-height-max:var(--cds-layout-size-height-md,2.5rem)}.cds--layout--size-lg{--cds-layout-size-height-context:var(--cds-layout-size-height-lg,3rem);--cds-layout-size-height:var(--cds-layout-size-height-context)}.cds--layout-constraint--size__default-lg{--cds-layout-size-height:var(--cds-layout-size-height-context,var(--cds-layout-size-height-lg,3rem))}.cds--layout-constraint--size__min-lg{--cds-layout-size-height-min:var(--cds-layout-size-height-lg,3rem)}.cds--layout-constraint--size__max-lg{--cds-layout-size-height-max:var(--cds-layout-size-height-lg,3rem)}.cds--layout--size-xl{--cds-layout-size-height-context:var(--cds-layout-size-height-xl,4rem);--cds-layout-size-height:var(--cds-layout-size-height-context)}.cds--layout-constraint--size__default-xl{--cds-layout-size-height:var(--cds-layout-size-height-context,var(--cds-layout-size-height-xl,4rem))}.cds--layout-constraint--size__min-xl{--cds-layout-size-height-min:var(--cds-layout-size-height-xl,4rem)}.cds--layout-constraint--size__max-xl{--cds-layout-size-height-max:var(--cds-layout-size-height-xl,4rem)}.cds--layout--size-2xl{--cds-layout-size-height-context:var(--cds-layout-size-height-2xl,5rem);--cds-layout-size-height:var(--cds-layout-size-height-context)}.cds--layout-constraint--size__default-2xl{--cds-layout-size-height:var(--cds-layout-size-height-context,var(--cds-layout-size-height-2xl,5rem))}.cds--layout-constraint--size__min-2xl{--cds-layout-size-height-min:var(--cds-layout-size-height-2xl,5rem)}.cds--layout-constraint--size__max-2xl{--cds-layout-size-height-max:var(--cds-layout-size-height-2xl,5rem)}.cds--layout--density-condensed{--cds-layout-density-padding-inline-context:var(--cds-layout-density-padding-inline-condensed,0.5rem);--cds-layout-density-padding-inline:var(--cds-layout-density-padding-inline-context)}.cds--layout-constraint--density__default-condensed{--cds-layout-density-padding-inline:var(--cds-layout-density-padding-inline-context,var(--cds-layout-density-padding-inline-condensed,0.5rem))}.cds--layout-constraint--density__min-condensed{--cds-layout-density-padding-inline-min:var(--cds-layout-density-padding-inline-condensed,0.5rem)}.cds--layout-constraint--density__max-condensed{--cds-layout-density-padding-inline-max:var(--cds-layout-density-padding-inline-condensed,0.5rem)}.cds--layout--density-normal{--cds-layout-density-padding-inline-context:var(--cds-layout-density-padding-inline-normal,1rem);--cds-layout-density-padding-inline:var(--cds-layout-density-padding-inline-context)}.cds--layout-constraint--density__default-normal{--cds-layout-density-padding-inline:var(--cds-layout-density-padding-inline-context,var(--cds-layout-density-padding-inline-normal,1rem))}.cds--layout-constraint--density__min-normal{--cds-layout-density-padding-inline-min:var(--cds-layout-density-padding-inline-normal,1rem)}.cds--layout-constraint--density__max-normal{--cds-layout-density-padding-inline-max:var(--cds-layout-density-padding-inline-normal,1rem)}:root{--cds-layout-size-height-xs:1.5rem;--cds-layout-size-height-sm:2rem;--cds-layout-size-height-md:2.5rem;--cds-layout-size-height-lg:3rem;--cds-layout-size-height-xl:4rem;--cds-layout-size-height-2xl:5rem;--cds-layout-size-height-min:0px;--cds-layout-size-height-max:999999999px;--cds-layout-density-padding-inline-condensed:0.5rem;--cds-layout-density-padding-inline-normal:1rem;--cds-layout-density-padding-inline-min:0px;--cds-layout-density-padding-inline-max:999999999px}@keyframes cds--hide-feedback{0%{opacity:1;visibility:inherit}to{opacity:0;visibility:hidden}}@keyframes cds--show-feedback{0%{opacity:0;visibility:hidden}to{opacity:1;visibility:inherit}}@keyframes cds--skeleton{0%{opacity:.3;transform:scaleX(0);transform-origin:left}20%{opacity:1;transform:scaleX(1);transform-origin:left}28%{transform:scaleX(1);transform-origin:right}51%{transform:scaleX(0);transform-origin:right}58%{transform:scaleX(0);transform-origin:right}82%{transform:scaleX(1);transform-origin:right}83%{transform:scaleX(1);transform-origin:left}96%{transform:scaleX(0);transform-origin:left}to{opacity:.3;transform:scaleX(0);transform-origin:left}}.cds--assistive-text,.cds--visually-hidden{block-size:1px;border:0;margin:-1px;overflow:hidden;padding:0;position:absolute;clip:rect(0,0,0,0);inline-size:1px;visibility:inherit;white-space:nowrap}.cds--popover-container{display:inline-block}.cds--popover-container:not(.cds--popover--auto-align){position:relative}.cds--popover--high-contrast .cds--popover{--cds-popover-background-color:var(--cds-background-inverse,#393939);--cds-popover-text-color:var(--cds-text-inverse,#fff)}.cds--popover--drop-shadow .cds--popover>.cds--popover-content{filter:drop-shadow(0 2px 2px rgba(0,0,0,.2))}.cds--popover--caret{--cds-popover-offset:0.625rem}.cds--popover{filter:var(--cds-popover-drop-shadow,none);inset:0;pointer-events:none;position:absolute;z-index:6000}.cds--popover-content{--cds-layout-size-height-sm:2rem;--cds-layout-size-height-md:2.5rem;--cds-layout-size-height-lg:3rem;background-color:var(--cds-popover-background-color,var(--cds-layer));border:0;border-radius:var(--cds-popover-border-radius,2px);box-sizing:border-box;color:var(--cds-popover-text-color,var(--cds-text-primary,#161616));display:none;font-family:inherit;font-size:100%;inline-size:-moz-max-content;inline-size:max-content;margin:0;max-inline-size:23rem;padding:0;pointer-events:auto;position:absolute;vertical-align:baseline;z-index:6000}.cds--layout--size-sm .cds--popover-content{--cds-layout-size-height:var(--cds-layout-size-height-sm)}.cds--layout--size-md .cds--popover-content{--cds-layout-size-height:var(--cds-layout-size-height-md)}.cds--layout--size-lg .cds--popover-content{--cds-layout-size-height:var(--cds-layout-size-height-lg)}.cds--popover-content *,.cds--popover-content :after,.cds--popover-content :before{box-sizing:inherit}.cds--popover--open>.cds--popover>.cds--popover-content{display:block}.cds--popover-content:before{content:\"\";display:none;position:absolute}.cds--popover--open>.cds--popover>.cds--popover-content:before{display:block}.cds--popover--auto-align.cds--popover-caret,.cds--popover-caret{background-color:var(--cds-popover-background-color,var(--cds-layer));display:none;position:absolute;will-change:transform;z-index:6000}.cds--popover--auto-align.cds--popover--caret.cds--popover--open>.cds--popover>.cds--popover-content>.cds--popover-caret,.cds--popover--caret.cds--popover--open>.cds--popover>.cds--popover-caret{display:block}.cds--popover--tab-tip>.cds--popover>.cds--popover-caret{display:none}.cds--popover--bottom:not(.cds--popover--auto-align)>.cds--popover>.cds--popover-content{inset-block-end:0;inset-inline-start:50%;transform:translate(-50%,calc(100% + var(--cds-popover-offset, 0rem)))}[dir=rtl] .cds--popover--bottom:not(.cds--popover--auto-align)>.cds--popover>.cds--popover-content{transform:translate(50%,calc(100% + var(--cds-popover-offset, 0rem)))}.cds--popover--bottom-left:not(.cds--popover--auto-align)>.cds--popover>.cds--popover-content,.cds--popover--bottom-start:not(.cds--popover--auto-align)>.cds--popover>.cds--popover-content{inset-block-end:0;inset-inline-start:0;transform:translate(calc(var(--cds-popover-offset, 0rem)*-1),calc(100% + var(--cds-popover-offset, 0rem)))}[dir=rtl] .cds--popover--bottom-left:not(.cds--popover--auto-align)>.cds--popover>.cds--popover-content,[dir=rtl] .cds--popover--bottom-start:not(.cds--popover--auto-align)>.cds--popover>.cds--popover-content{inset-inline-end:0;inset-inline-start:auto}.cds--popover--bottom-end:not(.cds--popover--auto-align)>.cds--popover>.cds--popover-content,.cds--popover--bottom-right:not(.cds--popover--auto-align)>.cds--popover>.cds--popover-content{inset-block-end:0;inset-inline-end:0;transform:translate(var(--cds-popover-offset,0),calc(100% + var(--cds-popover-offset, 0rem)))}[dir=rtl] .cds--popover--bottom-end:not(.cds--popover--auto-align)>.cds--popover>.cds--popover-content,[dir=rtl] .cds--popover--bottom-right:not(.cds--popover--auto-align)>.cds--popover>.cds--popover-content{inset-inline-start:0}.cds--popover--bottom-end>.cds--popover>.cds--popover-content:before,.cds--popover--bottom-left>.cds--popover>.cds--popover-content:before,.cds--popover--bottom-right>.cds--popover>.cds--popover-content:before,.cds--popover--bottom-start>.cds--popover>.cds--popover-content:before,.cds--popover--bottom>.cds--popover>.cds--popover-content:before{block-size:var(--cds-popover-offset,0);inset-block-start:0;inset-inline:0;transform:translateY(-100%)}.cds--popover--bottom-end>.cds--popover>.cds--popover-caret,.cds--popover--bottom-left>.cds--popover>.cds--popover-caret,.cds--popover--bottom-right>.cds--popover>.cds--popover-caret,.cds--popover--bottom-start>.cds--popover>.cds--popover-caret,.cds--popover--bottom>.cds--popover>.cds--popover-caret{block-size:var(--cds-popover-caret-height,.375rem);clip-path:polygon(0 100%,50% 0,100% 100%);inline-size:var(--cds-popover-caret-width,.75rem);inset-block-end:0;inset-inline-start:50%;transform:translate(-50%,var(--cds-popover-offset,0))}[dir=rtl] .cds--popover--bottom-end>.cds--popover>.cds--popover-caret,[dir=rtl] .cds--popover--bottom-left>.cds--popover>.cds--popover-caret,[dir=rtl] .cds--popover--bottom-right>.cds--popover>.cds--popover-caret,[dir=rtl] .cds--popover--bottom-start>.cds--popover>.cds--popover-caret,[dir=rtl] .cds--popover--bottom>.cds--popover>.cds--popover-caret{transform:translate(50%,var(--cds-popover-offset,0))}.cds--popover--bottom-end.cds--popover--auto-align>.cds--popover>.cds--popover-content>.cds--popover-caret,.cds--popover--bottom-left.cds--popover--auto-align>.cds--popover>.cds--popover-content>.cds--popover-caret,.cds--popover--bottom-right.cds--popover--auto-align>.cds--popover>.cds--popover-content>.cds--popover-caret,.cds--popover--bottom-start.cds--popover--auto-align>.cds--popover>.cds--popover-content>.cds--popover-caret,.cds--popover--bottom.cds--popover--auto-align>.cds--popover>.cds--popover-content>.cds--popover-caret{block-size:var(--cds-popover-caret-height,.375rem);clip-path:polygon(0 100%,50% 0,100% 100%);inline-size:var(--cds-popover-caret-width,.75rem)}.cds--popover--top:not(.cds--popover--auto-align)>.cds--popover>.cds--popover-content{inset-block-start:0;inset-inline-start:50%;transform:translate(-50%,calc(-100% - var(--cds-popover-offset, 0rem)))}[dir=rtl] .cds--popover--top:not(.cds--popover--auto-align)>.cds--popover>.cds--popover-content{transform:translate(50%,calc(-100% - var(--cds-popover-offset, 0rem)))}.cds--popover--top-left:not(.cds--popover--auto-align)>.cds--popover>.cds--popover-content,.cds--popover--top-start:not(.cds--popover--auto-align)>.cds--popover>.cds--popover-content{inset-block-start:0;inset-inline-start:0;transform:translate(calc(var(--cds-popover-offset, 0rem)*-1),calc(-100% - var(--cds-popover-offset, 0rem)))}[dir=rtl] .cds--popover--top-left:not(.cds--popover--auto-align)>.cds--popover>.cds--popover-content,[dir=rtl] .cds--popover--top-start:not(.cds--popover--auto-align)>.cds--popover>.cds--popover-content{inset-inline-end:0;inset-inline-start:auto}.cds--popover--top-end:not(.cds--popover--auto-align)>.cds--popover>.cds--popover-content,.cds--popover--top-right:not(.cds--popover--auto-align)>.cds--popover>.cds--popover-content{inset-block-start:0;inset-inline-end:0;transform:translate(var(--cds-popover-offset,0),calc(-100% - var(--cds-popover-offset, 0rem)))}[dir=rtl] .cds--popover--top-end:not(.cds--popover--auto-align)>.cds--popover>.cds--popover-content,[dir=rtl] .cds--popover--top-right:not(.cds--popover--auto-align)>.cds--popover>.cds--popover-content{inset-inline-start:0}.cds--popover--top-end>.cds--popover>.cds--popover-content:before,.cds--popover--top-left>.cds--popover>.cds--popover-content:before,.cds--popover--top-right>.cds--popover>.cds--popover-content:before,.cds--popover--top-start>.cds--popover>.cds--popover-content:before,.cds--popover--top>.cds--popover>.cds--popover-content:before{block-size:var(--cds-popover-offset,0);inset-block-end:0;inset-inline:0;transform:translateY(100%)}.cds--popover--top-end>.cds--popover>.cds--popover-caret,.cds--popover--top-left>.cds--popover>.cds--popover-caret,.cds--popover--top-right>.cds--popover>.cds--popover-caret,.cds--popover--top-start>.cds--popover>.cds--popover-caret,.cds--popover--top>.cds--popover>.cds--popover-caret{block-size:var(--cds-popover-caret-height,.375rem);clip-path:polygon(0 0,50% 100%,100% 0);inline-size:var(--cds-popover-caret-width,.75rem);inset-block-start:0;inset-inline-start:50%;transform:translate(-50%,calc(var(--cds-popover-offset, 0rem)*-1))}[dir=rtl] .cds--popover--top-end:not(.cds--popover--auto-align)>.cds--popover>.cds--popover-caret,[dir=rtl] .cds--popover--top-left:not(.cds--popover--auto-align)>.cds--popover>.cds--popover-caret,[dir=rtl] .cds--popover--top-right:not(.cds--popover--auto-align)>.cds--popover>.cds--popover-caret,[dir=rtl] .cds--popover--top-start:not(.cds--popover--auto-align)>.cds--popover>.cds--popover-caret,[dir=rtl] .cds--popover--top:not(.cds--popover--auto-align)>.cds--popover>.cds--popover-caret{transform:translate(50%,calc(var(--cds-popover-offset, 0rem)*-1))}.cds--popover--top-end.cds--popover--auto-align>.cds--popover>.cds--popover-content>.cds--popover-caret,.cds--popover--top-left.cds--popover--auto-align>.cds--popover>.cds--popover-content>.cds--popover-caret,.cds--popover--top-right.cds--popover--auto-align>.cds--popover>.cds--popover-content>.cds--popover-caret,.cds--popover--top-start.cds--popover--auto-align>.cds--popover>.cds--popover-content>.cds--popover-caret,.cds--popover--top.cds--popover--auto-align>.cds--popover>.cds--popover-content>.cds--popover-caret{block-size:var(--cds-popover-caret-height,.375rem);clip-path:polygon(0 0,50% 100%,100% 0);inline-size:var(--cds-popover-caret-width,.75rem)}.cds--popover--right:not(.cds--popover--auto-align)>.cds--popover>.cds--popover-content{inset-block-start:50%;inset-inline-start:100%;transform:translate(var(--cds-popover-offset,0),-50%)}.cds--popover--right-start:not(.cds--popover--auto-align)>.cds--popover>.cds--popover-content,.cds--popover--right-top:not(.cds--popover--auto-align)>.cds--popover>.cds--popover-content{inset-block-start:50%;inset-inline-start:100%;transform:translate(var(--cds-popover-offset,0),calc(var(--cds-popover-offset, 0rem)*.5*-1 - 16px))}.cds--popover--right-bottom:not(.cds--popover--auto-align)>.cds--popover>.cds--popover-content,.cds--popover--right-end:not(.cds--popover--auto-align)>.cds--popover>.cds--popover-content{inset-block-end:50%;inset-inline-start:100%;transform:translate(var(--cds-popover-offset,0),calc(var(--cds-popover-offset, 0rem)*.5 + 16px))}[dir=rtl] .cds--popover--right-bottom:not(.cds--popover--auto-align)>.cds--popover>.cds--popover-content,[dir=rtl] .cds--popover--right-end:not(.cds--popover--auto-align)>.cds--popover>.cds--popover-content,[dir=rtl] .cds--popover--right-start:not(.cds--popover--auto-align)>.cds--popover>.cds--popover-content,[dir=rtl] .cds--popover--right-top:not(.cds--popover--auto-align)>.cds--popover>.cds--popover-content,[dir=rtl] .cds--popover--right:not(.cds--popover--auto-align)>.cds--popover>.cds--popover-content{inset-inline-end:100%;inset-inline-start:auto}.cds--popover--right-bottom>.cds--popover>.cds--popover-content:before,.cds--popover--right-end>.cds--popover>.cds--popover-content:before,.cds--popover--right-start>.cds--popover>.cds--popover-content:before,.cds--popover--right-top>.cds--popover>.cds--popover-content:before,.cds--popover--right>.cds--popover>.cds--popover-content:before{inline-size:var(--cds-popover-offset,0);inset-block:0;inset-inline-start:0;transform:translateX(-100%)}.cds--popover--right-bottom:not(.cds--popover--auto-align)>.cds--popover>.cds--popover-caret,.cds--popover--right-end:not(.cds--popover--auto-align)>.cds--popover>.cds--popover-caret,.cds--popover--right-start:not(.cds--popover--auto-align)>.cds--popover>.cds--popover-caret,.cds--popover--right-top:not(.cds--popover--auto-align)>.cds--popover>.cds--popover-caret,.cds--popover--right:not(.cds--popover--auto-align)>.cds--popover>.cds--popover-caret{block-size:var(--cds-popover-caret-width,.75rem);clip-path:polygon(0 50%,100% 0,100% 100%);inline-size:var(--cds-popover-caret-height,.375rem);inset-block-start:50%;inset-inline-start:100%;transform:translate(calc(var(--cds-popover-offset, 0rem) - 100%),-50%)}[dir=rtl] .cds--popover--right-bottom:not(.cds--popover--auto-align)>.cds--popover>.cds--popover-caret,[dir=rtl] .cds--popover--right-end:not(.cds--popover--auto-align)>.cds--popover>.cds--popover-caret,[dir=rtl] .cds--popover--right-start:not(.cds--popover--auto-align)>.cds--popover>.cds--popover-caret,[dir=rtl] .cds--popover--right-top:not(.cds--popover--auto-align)>.cds--popover>.cds--popover-caret,[dir=rtl] .cds--popover--right:not(.cds--popover--auto-align)>.cds--popover>.cds--popover-caret{inset-inline-end:100%;inset-inline-start:auto}.cds--popover--right-bottom.cds--popover--auto-align>.cds--popover>.cds--popover-content>.cds--popover-caret,.cds--popover--right-end.cds--popover--auto-align>.cds--popover>.cds--popover-content>.cds--popover-caret,.cds--popover--right-start.cds--popover--auto-align>.cds--popover>.cds--popover-content>.cds--popover-caret,.cds--popover--right-top.cds--popover--auto-align>.cds--popover>.cds--popover-content>.cds--popover-caret,.cds--popover--right.cds--popover--auto-align>.cds--popover>.cds--popover-content>.cds--popover-caret{block-size:var(--cds-popover-caret-width,.75rem);clip-path:polygon(0 50%,100% 0,100% 100%);inline-size:var(--cds-popover-caret-height,.375rem)}.cds--popover--left:not(.cds--popover--auto-align)>.cds--popover>.cds--popover-content{inset-block-start:50%;inset-inline-end:100%;transform:translate(calc(var(--cds-popover-offset, 0rem)*-1 + .1px),-50%)}.cds--popover--left-start:not(.cds--popover--auto-align)>.cds--popover>.cds--popover-content,.cds--popover--left-top:not(.cds--popover--auto-align)>.cds--popover>.cds--popover-content{inset-block-start:50%;inset-inline-end:100%;transform:translate(calc(var(--cds-popover-offset, 0rem)*-1),calc(var(--cds-popover-offset, 0rem)*-.5 - 16px))}.cds--popover--left-bottom:not(.cds--popover--auto-align)>.cds--popover>.cds--popover-content,.cds--popover--left-end:not(.cds--popover--auto-align)>.cds--popover>.cds--popover-content{inset-block-end:50%;inset-inline-end:100%;transform:translate(calc(var(--cds-popover-offset, 0rem)*-1),calc(var(--cds-popover-offset, 0rem)*.5 + 16px))}[dir=rtl] .cds--popover--left-bottom:not(.cds--popover--auto-align)>.cds--popover>.cds--popover-content,[dir=rtl] .cds--popover--left-end:not(.cds--popover--auto-align)>.cds--popover>.cds--popover-content,[dir=rtl] .cds--popover--left-start:not(.cds--popover--auto-align)>.cds--popover>.cds--popover-content,[dir=rtl] .cds--popover--left-top:not(.cds--popover--auto-align)>.cds--popover>.cds--popover-content,[dir=rtl] .cds--popover--left:not(.cds--popover--auto-align)>.cds--popover>.cds--popover-content{inset-inline-end:auto;inset-inline-start:100%}.cds--popover--left-bottom>.cds--popover>.cds--popover-content:before,.cds--popover--left-end>.cds--popover>.cds--popover-content:before,.cds--popover--left-start>.cds--popover>.cds--popover-content:before,.cds--popover--left-top>.cds--popover>.cds--popover-content:before,.cds--popover--left>.cds--popover>.cds--popover-content:before{inline-size:var(--cds-popover-offset,0);inset-block:0;inset-inline-end:0;transform:translateX(100%)}.cds--popover--left-bottom:not(.cds--popover--auto-align)>.cds--popover>.cds--popover-caret,.cds--popover--left-end:not(.cds--popover--auto-align)>.cds--popover>.cds--popover-caret,.cds--popover--left-start:not(.cds--popover--auto-align)>.cds--popover>.cds--popover-caret,.cds--popover--left-top:not(.cds--popover--auto-align)>.cds--popover>.cds--popover-caret,.cds--popover--left:not(.cds--popover--auto-align)>.cds--popover>.cds--popover-caret{block-size:var(--cds-popover-caret-width,.75rem);clip-path:polygon(0 0,100% 50%,0 100%);inline-size:var(--cds-popover-caret-height,.375rem);inset-block-start:50%;inset-inline-end:100%;transform:translate(calc(var(--cds-popover-offset, 0rem)*-1 + 100%),-50%)}[dir=rtl] .cds--popover--left-bottom:not(.cds--popover--auto-align)>.cds--popover>.cds--popover-caret,[dir=rtl] .cds--popover--left-end:not(.cds--popover--auto-align)>.cds--popover>.cds--popover-caret,[dir=rtl] .cds--popover--left-start:not(.cds--popover--auto-align)>.cds--popover>.cds--popover-caret,[dir=rtl] .cds--popover--left-top:not(.cds--popover--auto-align)>.cds--popover>.cds--popover-caret,[dir=rtl] .cds--popover--left:not(.cds--popover--auto-align)>.cds--popover>.cds--popover-caret{inset-inline-end:auto;inset-inline-start:100%}.cds--popover--left-bottom.cds--popover--auto-align>.cds--popover>.cds--popover-content>.cds--popover-caret,.cds--popover--left-end.cds--popover--auto-align>.cds--popover>.cds--popover-content>.cds--popover-caret,.cds--popover--left-start.cds--popover--auto-align>.cds--popover>.cds--popover-content>.cds--popover-caret,.cds--popover--left-top.cds--popover--auto-align>.cds--popover>.cds--popover-content>.cds--popover-caret,.cds--popover--left.cds--popover--auto-align>.cds--popover>.cds--popover-content>.cds--popover-caret{block-size:var(--cds-popover-caret-width,.75rem);clip-path:polygon(0 0,100% 50%,0 100%);inline-size:var(--cds-popover-caret-height,.375rem)}.cds--popover--tab-tip>.cds--popover>.cds--popover-content{border-radius:0}.cds--popover--tab-tip .cds--popover{will-change:filter}.cds--popover--tab-tip__button{align-items:center;-webkit-appearance:none;-moz-appearance:none;appearance:none;background:none;block-size:2rem;border:0;box-sizing:border-box;cursor:pointer;display:inline-block;display:inline-flex;font-family:inherit;font-size:100%;inline-size:100%;inline-size:2rem;justify-content:center;margin:0;padding:0;position:relative;text-align:start;vertical-align:baseline}.cds--popover--tab-tip__button *,.cds--popover--tab-tip__button :after,.cds--popover--tab-tip__button :before{box-sizing:inherit}.cds--popover--tab-tip__button::-moz-focus-inner{border:0}.cds--popover--tab-tip__button:focus{outline:2px solid var(--cds-focus,#0f62fe);outline-offset:-2px}@media screen and (prefers-contrast){.cds--popover--tab-tip__button:focus{outline-style:dotted}}.cds--popover--tab-tip__button:hover{background-color:var(--cds-layer-hover)}.cds--popover--tab-tip.cds--popover--open .cds--popover--tab-tip__button{background:var(--cds-layer);box-shadow:0 2px 2px rgba(0,0,0,.2)}.cds--popover--tab-tip.cds--popover--open .cds--popover--tab-tip__button:not(:focus):after{background:var(--cds-layer);block-size:2px;content:\"\";inline-size:100%;inset-block-end:0;position:absolute;z-index:6001}.cds--popover--tab-tip__button svg{fill:var(--cds-icon-primary,#161616)}.cds--tooltip{--cds-popover-offset:12px}.cds--tooltip-content{color:var(--cds-text-inverse,#fff);font-size:var(--cds-body-01-font-size,.875rem);font-weight:var(--cds-body-01-font-weight,400);letter-spacing:var(--cds-body-01-letter-spacing,.16px);line-height:var(--cds-body-01-line-height,1.42857);max-inline-size:18rem;padding:var(--cds-tooltip-padding-block,1rem) var(--cds-tooltip-padding-inline,1rem)}.cds--icon-tooltip{--cds-tooltip-padding-block:0.125rem;--cds-popover-caret-width:0.5rem;--cds-popover-caret-height:0.25rem;--cds-popover-offset:0.5rem}.cds--icon-tooltip .cds--tooltip-content{font-size:var(--cds-body-compact-01-font-size,.875rem);font-weight:var(--cds-body-compact-01-font-weight,400);letter-spacing:var(--cds-body-compact-01-letter-spacing,.16px);line-height:var(--cds-body-compact-01-line-height,1.28572)}.cds--definition-term{-webkit-appearance:none;-moz-appearance:none;appearance:none;background:none;border:0;border-block-end:1px dotted var(--cds-border-strong);border-radius:0;box-sizing:border-box;color:var(--cds-text-primary,#161616);cursor:pointer;display:inline-block;font-family:inherit;font-size:100%;inline-size:100%;margin:0;padding:0;text-align:start;vertical-align:baseline}.cds--definition-term *,.cds--definition-term :after,.cds--definition-term :before{box-sizing:inherit}.cds--definition-term::-moz-focus-inner{border:0}.cds--definition-term:focus{border-block-end-color:var(--cds-border-interactive,#0f62fe);outline:1px solid var(--cds-focus,#0f62fe)}@media screen and (prefers-contrast){.cds--definition-term:focus{outline-style:dotted}}.cds--definition-term:hover{border-block-end-color:var(--cds-border-interactive,#0f62fe)}.cds--definition-tooltip{font-size:var(--cds-body-01-font-size,.875rem);font-weight:var(--cds-body-01-font-weight,400);letter-spacing:var(--cds-body-01-letter-spacing,.16px);line-height:var(--cds-body-01-line-height,1.42857);max-inline-size:11rem;padding:.5rem 1rem}.cds--btn{--cds-layout-size-height-local:clamp(max(var(--cds-layout-size-height-min),var(--cds-layout-size-height-sm)),var(--cds-layout-size-height,var(--cds-layout-size-height-lg)),min(var(--cds-layout-size-height-max),var(--cds-layout-size-height-2xl)));--cds-layout-density-padding-inline-local:clamp(var(--cds-layout-density-padding-inline-min),var(--cds-layout-density-padding-inline,var(--cds-layout-density-padding-inline-normal)),var(--cds-layout-density-padding-inline-max));--temp-1lh:(var(--cds-body-compact-01-line-height,1.28572) * 1em);--temp-expressive-1lh:(var(--cds-body-compact-02-line-height,1.375) * 1em);--temp-padding-block-max:calc((var(--cds-layout-size-height-lg) - var(--temp-1lh))/2 - 0.0625rem);border:0;border-radius:0;box-sizing:border-box;cursor:pointer;display:inline-flex;flex-shrink:0;font-family:inherit;font-size:100%;font-size:var(--cds-body-compact-01-font-size,.875rem);font-weight:var(--cds-body-compact-01-font-weight,400);inline-size:-moz-max-content;inline-size:max-content;justify-content:space-between;letter-spacing:var(--cds-body-compact-01-letter-spacing,.16px);line-height:var(--cds-body-compact-01-line-height,1.28572);margin:0;max-inline-size:20rem;min-block-size:var(--cds-layout-size-height-local);outline:none;padding:0;padding-block:min((var(--cds-layout-size-height-local) - var(--temp-1lh))/2 - .0625rem,var(--temp-padding-block-max));padding-inline:calc(var(--cds-layout-density-padding-inline-local) - .0625rem) calc(var(--cds-layout-density-padding-inline-local)*3 + .9375rem);position:relative;text-align:start;text-decoration:none;transition:background 70ms cubic-bezier(0,0,.38,.9),box-shadow 70ms cubic-bezier(0,0,.38,.9),border-color 70ms cubic-bezier(0,0,.38,.9),outline 70ms cubic-bezier(0,0,.38,.9);vertical-align:baseline;vertical-align:top}.cds--btn *,.cds--btn :after,.cds--btn :before{box-sizing:inherit}.cds--btn.cds--btn--disabled,.cds--btn.cds--btn--disabled:focus,.cds--btn.cds--btn--disabled:hover,.cds--btn:disabled,.cds--btn:focus:disabled,.cds--btn:hover:disabled{background:var(--cds-button-disabled,#c6c6c6);border-color:var(--cds-button-disabled,#c6c6c6);box-shadow:none;color:var(--cds-text-on-color-disabled,#8d8d8d);cursor:not-allowed}.cds--btn .cds--btn__icon{block-size:1rem;flex-shrink:0;inline-size:1rem;inset-block-start:min((var(--cds-layout-size-height-local) - 1rem)/2 - .0625rem,var(--temp-padding-block-max));inset-inline-end:var(--cds-layout-density-padding-inline-local);margin-block-start:.0625rem;position:absolute}.cds--btn::-moz-focus-inner{border:0;padding:0}.cds--btn--primary{background-color:var(--cds-button-primary,#0f62fe);border:1px solid transparent;color:var(--cds-text-on-color,#fff)}.cds--btn--primary:hover{background-color:var(--cds-button-primary-hover,#0050e6)}.cds--btn--primary:focus{border-color:var(--cds-button-focus-color,var(--cds-focus,#0f62fe));box-shadow:inset 0 0 0 1px var(--cds-button-focus-color,var(--cds-focus,#0f62fe)),inset 0 0 0 2px var(--cds-background,#fff)}.cds--btn--primary:active{background-color:var(--cds-button-primary-active,#002d9c)}.cds--btn--primary .cds--btn__icon,.cds--btn--primary .cds--btn__icon path:not([data-icon-path]):not([fill=none]){fill:currentColor}.cds--btn--primary:hover,.cds--btn--secondary{color:var(--cds-text-on-color,#fff)}.cds--btn--secondary{background-color:var(--cds-button-secondary,#393939);border:1px solid transparent}.cds--btn--secondary:hover{background-color:var(--cds-button-secondary-hover,#474747)}.cds--btn--secondary:focus{border-color:var(--cds-button-focus-color,var(--cds-focus,#0f62fe));box-shadow:inset 0 0 0 1px var(--cds-button-focus-color,var(--cds-focus,#0f62fe)),inset 0 0 0 2px var(--cds-background,#fff)}.cds--btn--secondary:active{background-color:var(--cds-button-secondary-active,#6f6f6f)}.cds--btn--secondary .cds--btn__icon,.cds--btn--secondary .cds--btn__icon path:not([data-icon-path]):not([fill=none]){fill:currentColor}.cds--btn--secondary:focus,.cds--btn--secondary:hover{color:var(--cds-text-on-color,#fff)}.cds--btn--tertiary{background-color:transparent;border-color:var(--cds-button-tertiary,#0f62fe);border-style:solid;border-width:1px;color:var(--cds-button-tertiary,#0f62fe)}.cds--btn--tertiary:hover{background-color:var(--cds-button-tertiary-hover,#0050e6)}.cds--btn--tertiary:focus{border-color:var(--cds-button-focus-color,var(--cds-focus,#0f62fe));box-shadow:inset 0 0 0 1px var(--cds-button-focus-color,var(--cds-focus,#0f62fe)),inset 0 0 0 2px var(--cds-background,#fff)}.cds--btn--tertiary .cds--btn__icon,.cds--btn--tertiary .cds--btn__icon path:not([data-icon-path]):not([fill=none]){fill:currentColor}.cds--btn--tertiary:focus,.cds--btn--tertiary:hover{color:var(--cds-text-inverse,#fff)}.cds--btn--tertiary:focus{background-color:var(--cds-button-tertiary,#0f62fe)}.cds--btn--tertiary:active{background-color:var(--cds-button-tertiary-active,#002d9c);border-color:transparent;color:var(--cds-text-inverse,#fff)}.cds--btn--tertiary.cds--btn--disabled,.cds--btn--tertiary.cds--btn--disabled:focus,.cds--btn--tertiary.cds--btn--disabled:hover,.cds--btn--tertiary:disabled,.cds--btn--tertiary:focus:disabled,.cds--btn--tertiary:hover:disabled{background:transparent;color:var(--cds-text-on-color-disabled,#8d8d8d);outline:none}.cds--btn--ghost{background-color:transparent;border:1px solid transparent;color:var(--cds-link-primary,#0f62fe);padding-inline-end:calc(var(--cds-layout-density-padding-inline-local) - .0625rem)}.cds--btn--ghost:hover{background-color:var(--cds-background-hover,hsla(0,0%,55%,.12))}.cds--btn--ghost:focus{border-color:var(--cds-button-focus-color,var(--cds-focus,#0f62fe));box-shadow:inset 0 0 0 1px var(--cds-button-focus-color,var(--cds-focus,#0f62fe)),inset 0 0 0 2px var(--cds-background,#fff)}.cds--btn--ghost .cds--btn__icon,.cds--btn--ghost .cds--btn__icon path:not([data-icon-path]):not([fill=none]){fill:currentColor}.cds--btn--ghost .cds--btn__icon{align-self:center;margin-inline-start:.5rem;position:static}.cds--btn--ghost:active,.cds--btn--ghost:hover{color:var(--cds-link-primary-hover,#0043ce)}.cds--btn--ghost:active{background-color:var(--cds-background-active,hsla(0,0%,55%,.5))}.cds--btn--ghost.cds--btn--disabled,.cds--btn--ghost.cds--btn--disabled:focus,.cds--btn--ghost.cds--btn--disabled:hover,.cds--btn--ghost:disabled,.cds--btn--ghost:focus:disabled,.cds--btn--ghost:hover:disabled{background:transparent;border-color:transparent;color:var(--cds-text-on-color-disabled,#8d8d8d);outline:none}.cds--btn--ghost:not([disabled]) svg{fill:var(--cds-icon-primary,#161616)}.cds--btn--icon-only{block-size:var(--cds-layout-size-height-local);inline-size:var(--cds-layout-size-height-local);justify-content:center;padding:0;padding-block-start:min((var(--cds-layout-size-height-local) - 1rem)/2 - .0625rem,var(--temp-padding-block-max))}.cds--btn--icon-only>:first-child{min-inline-size:1rem}.cds--btn--icon-only .cds--btn__icon{position:static}.cds--btn--icon-only.cds--btn--danger--ghost .cds--btn__icon,.cds--btn--icon-only.cds--btn--ghost .cds--btn__icon{margin:0}.cds--btn--icon-only.cds--btn--danger--ghost{padding-inline-end:calc(var(--cds-layout-density-padding-inline-local) - 1rem)}.cds--btn--md:not(.cds--btn--icon-only) .cds--btn__icon,.cds--btn--sm:not(.cds--btn--icon-only) .cds--btn__icon{margin-block-start:0}.cds--btn--icon-only.cds--btn--selected{background:var(--cds-background-selected,hsla(0,0%,55%,.2))}.cds--btn path[data-icon-path=inner-path]{fill:none}.cds--btn--ghost.cds--btn--icon-only .cds--btn__icon,.cds--btn--ghost.cds--btn--icon-only .cds--btn__icon path:not([data-icon-path]):not([fill=none]){fill:var(--cds-icon-primary,#161616)}.cds--btn--ghost.cds--btn--icon-only[disabled] .cds--btn__icon,.cds--btn--ghost.cds--btn--icon-only[disabled] .cds--btn__icon path:not([data-icon-path]):not([fill=none]),.cds--btn.cds--btn--icon-only.cds--btn--ghost[disabled]:hover .cds--btn__icon{fill:var(--cds-icon-on-color-disabled,#8d8d8d)}.cds--btn--ghost.cds--btn--icon-only[disabled],.cds--icon-tooltip--disabled .cds--tooltip-trigger__wrapper{cursor:not-allowed}.cds--icon-tooltip--disabled .cds--btn--icon-only[disabled]{pointer-events:none}.cds--btn--danger{background-color:var(--cds-button-danger-primary,#da1e28);border:1px solid transparent;color:var(--cds-text-on-color,#fff)}.cds--btn--danger:hover{background-color:var(--cds-button-danger-hover,#b81921)}.cds--btn--danger:focus{border-color:var(--cds-button-focus-color,var(--cds-focus,#0f62fe));box-shadow:inset 0 0 0 1px var(--cds-button-focus-color,var(--cds-focus,#0f62fe)),inset 0 0 0 2px var(--cds-background,#fff)}.cds--btn--danger:active{background-color:var(--cds-button-danger-active,#750e13)}.cds--btn--danger .cds--btn__icon,.cds--btn--danger .cds--btn__icon path:not([data-icon-path]):not([fill=none]){fill:currentColor}.cds--btn--danger:hover{color:var(--cds-text-on-color,#fff)}.cds--btn--danger--tertiary{background-color:transparent;border-color:var(--cds-button-danger-secondary,#da1e28);border-style:solid;border-width:1px;color:var(--cds-button-danger-secondary,#da1e28)}.cds--btn--danger--tertiary:hover{background-color:var(--cds-button-danger-hover,#b81921)}.cds--btn--danger--tertiary:focus{border-color:var(--cds-button-focus-color,var(--cds-focus,#0f62fe));box-shadow:inset 0 0 0 1px var(--cds-button-focus-color,var(--cds-focus,#0f62fe)),inset 0 0 0 2px var(--cds-background,#fff)}.cds--btn--danger--tertiary .cds--btn__icon,.cds--btn--danger--tertiary .cds--btn__icon path:not([data-icon-path]):not([fill=none]){fill:currentColor}.cds--btn--danger--tertiary:hover{border-color:var(--cds-button-danger-hover,#b81921);color:var(--cds-text-on-color,#fff)}.cds--btn--danger--tertiary:focus{background-color:var(--cds-button-danger-primary,#da1e28);color:var(--cds-text-on-color,#fff)}.cds--btn--danger--tertiary:active{background-color:var(--cds-button-danger-active,#750e13);border-color:var(--cds-button-danger-active,#750e13);color:var(--cds-text-on-color,#fff)}.cds--btn--danger--tertiary.cds--btn--disabled,.cds--btn--danger--tertiary.cds--btn--disabled:focus,.cds--btn--danger--tertiary.cds--btn--disabled:hover,.cds--btn--danger--tertiary:disabled,.cds--btn--danger--tertiary:focus:disabled,.cds--btn--danger--tertiary:hover:disabled{background:transparent;color:var(--cds-text-on-color-disabled,#8d8d8d);outline:none}.cds--btn--danger--ghost{background-color:transparent;border:1px solid transparent;color:var(--cds-button-danger-secondary,#da1e28);padding-inline-end:calc(var(--cds-layout-density-padding-inline-local) - .0625rem)}.cds--btn--danger--ghost:hover{background-color:var(--cds-button-danger-hover,#b81921)}.cds--btn--danger--ghost:focus{border-color:var(--cds-button-focus-color,var(--cds-focus,#0f62fe));box-shadow:inset 0 0 0 1px var(--cds-button-focus-color,var(--cds-focus,#0f62fe)),inset 0 0 0 2px var(--cds-background,#fff)}.cds--btn--danger--ghost:active{background-color:var(--cds-button-danger-active,#750e13)}.cds--btn--danger--ghost .cds--btn__icon,.cds--btn--danger--ghost .cds--btn__icon path:not([data-icon-path]):not([fill=none]){fill:currentColor}.cds--btn--danger--ghost .cds--btn__icon{margin-inline-start:.5rem;position:static}.cds--btn--danger--ghost:active,.cds--btn--danger--ghost:hover{color:var(--cds-text-on-color,#fff)}.cds--btn--danger--ghost.cds--btn--disabled,.cds--btn--danger--ghost.cds--btn--disabled:focus,.cds--btn--danger--ghost.cds--btn--disabled:hover,.cds--btn--danger--ghost:disabled,.cds--btn--danger--ghost:focus:disabled,.cds--btn--danger--ghost:hover:disabled{background:transparent;border-color:transparent;color:var(--cds-text-disabled,hsla(0,0%,9%,.25));outline:none}.cds--btn--expressive{font-size:var(--cds-body-compact-02-font-size,1rem);font-weight:var(--cds-body-compact-02-font-weight,400);letter-spacing:var(--cds-body-compact-02-letter-spacing,0);line-height:var(--cds-body-compact-02-line-height,1.375);padding-block:min((var(--cds-layout-size-height-local) - var(--temp-expressive-1lh))/2 - .0625rem,var(--temp-padding-block-max))}.cds--btn--icon-only.cds--btn--expressive{padding:12px 13px}.cds--btn.cds--btn--expressive .cds--btn__icon{block-size:1.25rem;inline-size:1.25rem}.cds--btn-set .cds--btn.cds--btn--expressive{max-inline-size:20rem}.cds--btn.cds--skeleton{background:var(--cds-skeleton-background,#e8e8e8);border:none;box-shadow:none;inline-size:9.375rem;padding:0;pointer-events:none;position:relative}.cds--btn.cds--skeleton:active,.cds--btn.cds--skeleton:focus,.cds--btn.cds--skeleton:hover{border:none;cursor:default;outline:none}.cds--btn.cds--skeleton:before{animation:cds--skeleton 3s ease-in-out infinite;background:var(--cds-skeleton-element,#c6c6c6);block-size:100%;content:\"\";inline-size:100%;inset-inline-start:0;position:absolute;will-change:transform-origin,transform,opacity}@media (prefers-reduced-motion:reduce){.cds--btn.cds--skeleton:before{animation:none}}.cds--btn-set{display:flex}.cds--btn-set--stacked{flex-direction:column}.cds--btn-set .cds--btn{inline-size:100%;max-inline-size:12.25rem}.cds--btn-set .cds--btn:not(:focus){box-shadow:-.0625rem 0 0 0 var(--cds-button-separator,#e0e0e0)}.cds--btn-set .cds--btn:first-of-type:not(:focus),.cds--btn-set .cds--btn:focus+.cds--btn{box-shadow:inherit}.cds--btn-set--stacked .cds--btn:not(:focus){box-shadow:0 -.0625rem 0 0 var(--cds-button-separator,#e0e0e0)}.cds--btn-set--stacked .cds--btn:first-of-type:not(:focus){box-shadow:inherit}.cds--btn-set .cds--btn.cds--btn--disabled{box-shadow:-.0625rem 0 0 0 var(--cds-icon-on-color-disabled,#8d8d8d)}.cds--btn-set .cds--btn.cds--btn--disabled:first-of-type{box-shadow:none}.cds--btn-set--stacked .cds--btn.cds--btn--disabled{box-shadow:0 -.0625rem 0 0 var(--cds-layer-selected-disabled,#8d8d8d)}.cds--btn-set--stacked .cds--btn.cds--btn--disabled:first-of-type{box-shadow:none}.cds--btn-set .cds--btn.cds--btn--loading{background-color:transparent;border-color:transparent;box-shadow:none}@media (forced-colors:active),screen and (-ms-high-contrast:active){.cds--btn:focus{color:Highlight;outline:1px solid Highlight}.cds--btn--ghost.cds--btn--icon-only .cds--btn__icon,.cds--btn--ghost.cds--btn--icon-only .cds--btn__icon path:not([data-icon-path]):not([fill=none]){fill:ButtonText}}[dir=rtl] .cds--btn-set .cds--btn:not(:focus){box-shadow:.0625rem 0 0 0 var(--cds-button-separator,#e0e0e0)}.cds--modal,:host(cds-modal){align-items:center;background-color:var(--cds-overlay,hsla(0,0%,9%,.5));block-size:100vh;content:\"\";display:flex;inline-size:100vw;inset-block-start:0;inset-inline-start:0;justify-content:center;opacity:0;position:fixed;transition:opacity .24s cubic-bezier(.4,.14,1,1),visibility 0ms linear .24s;visibility:hidden;z-index:9000}.cds--modal.is-visible{opacity:1;transition:opacity .24s cubic-bezier(0,0,.3,1),visibility 0ms linear;visibility:inherit}@media screen and (prefers-reduced-motion:reduce){.cds--modal.is-visible{transition:none}}.cds--modal .cds--date-picker--fluid .ccdsds--date-picker-input__wrapper .cds--date-picker__input,.cds--modal .cds--list-box__wrapper--fluid .cds--list-box,.cds--modal .cds--list-box__wrapper--fluid.cds--list-box__wrapper,.cds--modal .cds--number-input--fluid .cds--number__control-btn:after,.cds--modal .cds--number-input--fluid .cds--number__control-btn:before,.cds--modal .cds--number-input--fluid input[type=number],.cds--modal .cds--search--fluid .cds--search-input,.cds--modal .cds--select--fluid .cds--select-input,.cds--modal .cds--text-area--fluid .cds--text-area,.cds--modal .cds--text-area--fluid .cds--text-area__wrapper,.cds--modal .cds--text-area--fluid .cds--text-area__wrapper[data-invalid] .cds--text-area__divider+.cds--form-requirement,.cds--modal .cds--text-input--fluid .cds--text-input,:host(cds-modal) .cds--date-picker--fluid .ccdsds--date-picker-input__wrapper .cds--date-picker__input,:host(cds-modal) .cds--list-box__wrapper--fluid .cds--list-box,:host(cds-modal) .cds--list-box__wrapper--fluid.cds--list-box__wrapper,:host(cds-modal) .cds--number-input--fluid .cds--number__control-btn:after,:host(cds-modal) .cds--number-input--fluid .cds--number__control-btn:before,:host(cds-modal) .cds--number-input--fluid input[type=number],:host(cds-modal) .cds--search--fluid .cds--search-input,:host(cds-modal) .cds--select--fluid .cds--select-input,:host(cds-modal) .cds--text-area--fluid .cds--text-area,:host(cds-modal) .cds--text-area--fluid .cds--text-area__wrapper,:host(cds-modal) .cds--text-area--fluid .cds--text-area__wrapper[data-invalid] .cds--text-area__divider+.cds--form-requirement,:host(cds-modal) .cds--text-input--fluid .cds--text-input{background-color:var(--cds-field-01,#f4f4f4)}.cds--modal .cds--list-box__wrapper--fluid .cds--list-box__menu,:host(cds-modal) .cds--list-box__wrapper--fluid .cds--list-box__menu{background-color:var(--cds-layer-01,#f4f4f4)}.cds--modal .cds--list-box__menu-item:hover,:host(cds-modal) .cds--list-box__menu-item:hover{background-color:var(--cds-layer-hover-02,#e8e8e8)}.cds--modal .cds--list-box__menu-item--active,:host(cds-modal) .cds--list-box__menu-item--active{background-color:var(--cds-layer-selected-02,#e0e0e0)}.cds--modal .cds--list-box__menu-item--active:hover,:host(cds-modal) .cds--list-box__menu-item--active:hover{background-color:var(--cds-layer-selected-hover-02,#d1d1d1)}.cds--modal .cds--number-input--fluid .cds--number__control-btn:hover:after,.cds--modal .cds--number-input--fluid .cds--number__control-btn:hover:before,:host(cds-modal) .cds--number-input--fluid .cds--number__control-btn:hover:after,:host(cds-modal) .cds--number-input--fluid .cds--number__control-btn:hover:before{background-color:var(--cds-field-hover)}.cds--modal .cds--number-input--fluid .cds--number__control-btn:focus:after,.cds--modal .cds--number-input--fluid .cds--number__control-btn:focus:before,:host(cds-modal) .cds--number-input--fluid .cds--number__control-btn:focus:after,:host(cds-modal) .cds--number-input--fluid .cds--number__control-btn:focus:before{border-inline-start:2px solid var(--cds-focus,#0f62fe)}.cds--modal.is-visible .cds--modal-container{transform:translateZ(0);transition:transform .24s cubic-bezier(0,0,.3,1)}.cds--modal-container{background-color:var(--cds-layer);block-size:100%;display:grid;grid-template-columns:100%;grid-template-rows:auto 1fr auto;inline-size:100%;inset-block-start:0;max-block-size:100%;outline:3px solid transparent;outline-offset:-3px;position:fixed;transform:translate3d(0,-24px,0);transform-origin:top center;transition:transform .24s cubic-bezier(.4,.14,1,1)}@media (min-width:42rem){.cds--modal-container{block-size:auto;inline-size:84%;max-block-size:90%;position:static}}@media (min-width:66rem){.cds--modal-container{inline-size:60%;max-block-size:84%}}@media (min-width:82rem){.cds--modal-container{inline-size:48%}}.cds--modal-container .cds--modal-container-body{display:contents}.cds--modal-content,:host(cds-modal-body){color:var(--cds-text-primary,#161616);font-size:var(--cds-body-01-font-size,.875rem);font-weight:var(--cds-body-01-font-weight,400);font-weight:400;grid-column:1/-1;grid-row:2/-2;letter-spacing:var(--cds-body-01-letter-spacing,.16px);line-height:var(--cds-body-01-line-height,1.42857);overflow-y:auto;padding-block:.5rem 3rem;padding-inline:1rem 1rem;position:relative}.cds--modal-content:focus{outline:2px solid var(--cds-focus,#0f62fe);outline-offset:-2px}@media screen and (prefers-contrast){.cds--modal-content:focus{outline-style:dotted}}.cds--modal-content .cds--form--fluid,:host(cds-modal-body) .cds--form--fluid{margin-inline:-2rem}.cds--modal-content>p,.cds--modal-content__regular-content,:host(cds-modal-body)>p{font-size:var(--cds-body-01-font-size,.875rem);font-weight:var(--cds-body-01-font-weight,400);letter-spacing:var(--cds-body-01-letter-spacing,.16px);line-height:var(--cds-body-01-line-height,1.42857);padding-inline-end:calc(20% - 2rem)}.cds--modal-content--with-form{padding-inline-end:1rem}.cds--modal-header,:host(cds-modal-header){grid-column:1/-1;grid-row:1/1;margin-block-end:.5rem;padding-block-start:1rem;padding-inline:1rem 3rem}.cds--modal-header__label,:host(cds-modal-label){border:0;box-sizing:border-box;color:var(--cds-text-secondary,#525252);font-family:inherit;font-size:100%;font-size:var(--cds-label-01-font-size,.75rem);font-weight:var(--cds-label-01-font-weight,400);letter-spacing:var(--cds-label-01-letter-spacing,.32px);line-height:var(--cds-label-01-line-height,1.33333);margin:0;margin-block-end:.25rem;padding:0;vertical-align:baseline}.cds--modal-header__label *,.cds--modal-header__label :after,.cds--modal-header__label :before,:host(cds-modal-label) *,:host(cds-modal-label) :after,:host(cds-modal-label) :before{box-sizing:inherit}.cds--modal-header__heading,:host(cds-modal-heading){border:0;box-sizing:border-box;color:var(--cds-text-primary,#161616);font-family:inherit;font-size:100%;font-size:var(--cds-heading-03-font-size,1.25rem);font-weight:var(--cds-heading-03-font-weight,400);letter-spacing:var(--cds-heading-03-letter-spacing,0);line-height:var(--cds-heading-03-line-height,1.4);margin:0;padding:0;padding-inline-end:calc(20% - 3rem);vertical-align:baseline}.cds--modal-header__heading *,.cds--modal-header__heading :after,.cds--modal-header__heading :before,:host(cds-modal-heading) *,:host(cds-modal-heading) :after,:host(cds-modal-heading) :before{box-sizing:inherit}.cds--modal-container--xs .cds--modal-content__regular-content{padding-inline-end:1rem}.cds--modal-container--xs .cds--modal-content>p,.cds--modal-container--xs :host(cds-modal-body)>p{padding-inline-end:0}@media (min-width:42rem){.cds--modal-container--xs{inline-size:48%}}@media (min-width:66rem){.cds--modal-container--xs{inline-size:32%;max-block-size:48%}}@media (min-width:82rem){.cds--modal-container--xs{inline-size:24%}}.cds--modal-container--sm .cds--modal-content__regular-content{padding-inline-end:1rem}.cds--modal-container--sm .cds--modal-content>p,.cds--modal-container--sm :host(cds-modal-body)>p{padding-inline-end:0}@media (min-width:42rem){.cds--modal-container--sm{inline-size:60%}}@media (min-width:66rem){.cds--modal-container--sm{inline-size:42%;max-block-size:72%}.cds--modal-container--sm .cds--modal-content>p,.cds--modal-container--sm .cds--modal-content__regular-content,.cds--modal-container--sm :host(cds-modal-body)>p{padding-inline-end:20%}}@media (min-width:82rem){.cds--modal-container--sm{inline-size:36%}}@media (min-width:42rem){.cds--modal-container--lg{inline-size:96%}}@media (min-width:66rem){.cds--modal-container--lg{inline-size:84%;max-block-size:96%}}@media (min-width:82rem){.cds--modal-container--lg{inline-size:72%}}.cds--modal-scroll-content,:host(cds-modal[has-scrolling-content]) ::slotted(cds-modal-body){border-block-end:2px solid transparent;-webkit-mask-image:linear-gradient(to bottom,var(--cds-layer) calc(100% - 80px),transparent calc(100% - 48px),transparent 100%),linear-gradient(to left,var(--cds-layer) 0,16px,transparent 16px),linear-gradient(to right,var(--cds-layer) 0,2px,transparent 2px),linear-gradient(to top,var(--cds-layer) 0,2px,transparent 2px);mask-image:linear-gradient(to bottom,var(--cds-layer) calc(100% - 80px),transparent calc(100% - 48px),transparent 100%),linear-gradient(to left,var(--cds-layer) 0,16px,transparent 16px),linear-gradient(to right,var(--cds-layer) 0,2px,transparent 2px),linear-gradient(to top,var(--cds-layer) 0,2px,transparent 2px)}.cds--modal-scroll-content:has(.cds--autoalign),:host(cds-modal[has-scrolling-content]) :has(.cds--autoalign)::slotted(cds-modal-body){-webkit-mask-image:none;mask-image:none}.cds--modal-scroll-content>:last-child,:host(cds-modal[has-scrolling-content]) ::slotted(cds-modal-body)>:last-child{margin-block-end:1.5rem}.cds--modal-footer,:host(cds-modal-footer){block-size:4rem;display:flex;grid-column:1/-1;grid-row:-1/-1;justify-content:flex-end;margin-block-start:auto}.cds--modal-footer .cds--btn,:host(cds-modal-footer) .cds--btn{align-items:baseline;block-size:4rem;flex:0 1 50%;margin:0;max-inline-size:none}.cds--modal-footer .cds--btn:not(.cds--skeleton),:host(cds-modal-footer) .cds--btn:not(.cds--skeleton){padding-block:.875rem 2rem}.cds--modal-footer--three-button .cds--btn,:host(cds-modal-footer[has-three-buttons]) .cds--btn{align-items:flex-start;flex:0 1 25%}.cds--modal-close-button,:host(cds-modal-close-button){inset-block-start:0;inset-inline-end:0;position:absolute}.cds--modal-close{background-color:transparent;block-size:3rem;border:2px solid transparent;cursor:pointer;inline-size:3rem;padding:.75rem;transition:background-color .11s cubic-bezier(.2,0,.38,.9)}.cds--modal-close:hover{background-color:var(--cds-layer-hover)}.cds--modal-close:focus{border-color:var(--cds-focus,#0f62fe);outline:none}.cds--modal-close::-moz-focus-inner{border:0}.cds--modal-close__icon{block-size:1.25rem;fill:var(--cds-icon-primary,#161616);inline-size:1.25rem}.cds--body--with-modal-open{overflow:hidden}.cds--body--with-modal-open .cds--modal .cds--overflow-menu-options,.cds--body--with-modal-open .cds--modal .cds--tooltip,.cds--body--with-modal-open .cds--overflow-menu-options,.cds--body--with-modal-open :host(cds-modal) .cds--tooltip{z-index:9000}.cds--modal-container--full-width .cds--modal-content,.cds--modal-container--full-width :host(cds-modal-body){margin:0;padding:0}.cds--modal--decorator:has(.cds--ai-label).cds--modal,.cds--modal--slug.cds--modal{background-color:var(--cds-ai-overlay,rgba(0,17,65,.5))}.cds--modal--decorator:has(.cds--ai-label) .cds--modal-container,.cds--modal--slug .cds--modal-container{background:linear-gradient(to top,var(--cds-layer,var(--cds-ai-popover-background,#fff)) 0,var(--cds-ai-aura-start,rgba(69,137,255,.1)) 0,15%,var(--cds-ai-aura-end,hsla(0,0%,100%,0)) 50%) padding-box,linear-gradient(to top,var(--cds-layer,var(--cds-ai-popover-background,#fff)),var(--cds-layer,var(--cds-ai-popover-background,#fff))) padding-box,linear-gradient(to bottom,var(--cds-ai-border-start,rgba(166,200,255,.64)),var(--cds-ai-border-end,#78a9ff)) border-box,linear-gradient(to top,var(--cds-layer,var(--cds-ai-popover-background,#fff)),var(--cds-layer,var(--cds-ai-popover-background,#fff))) border-box;background-color:var(--cds-layer);border:1px solid transparent;box-shadow:inset 0 -80px 70px -65px var(--cds-ai-inner-shadow,rgba(69,137,255,.1)),0 24px 40px -24px var(--cds-ai-drop-shadow,rgba(15,98,254,.1))}.cds--modal--decorator:has(.cds--ai-label) .cds--modal-container:has(.cds--modal-footer,:host(cds-modal-footer)),.cds--modal--slug .cds--modal-container:has(.cds--modal-footer,:host(cds-modal-footer)){background:linear-gradient(to top,var(--cds-layer,var(--cds-ai-popover-background,#fff)) 64px,var(--cds-ai-aura-start,rgba(69,137,255,.1)) 64px,15%,var(--cds-ai-aura-end,hsla(0,0%,100%,0)) 50%) padding-box,linear-gradient(to top,var(--cds-layer,var(--cds-ai-popover-background,#fff)),var(--cds-layer,var(--cds-ai-popover-background,#fff))) padding-box,linear-gradient(to bottom,var(--cds-ai-border-start,rgba(166,200,255,.64)),var(--cds-ai-border-end,#78a9ff)) border-box,linear-gradient(to top,var(--cds-layer,var(--cds-ai-popover-background,#fff)),var(--cds-layer,var(--cds-ai-popover-background,#fff))) border-box;box-shadow:inset 0 -80px 0 -16px var(--cds-layer),inset 0 -160px 70px -65px var(--cds-ai-inner-shadow,rgba(69,137,255,.1)),0 24px 40px -24px var(--cds-ai-drop-shadow,rgba(15,98,254,.1))}.cds--modal--decorator .cds--modal-content.cds--modal-scroll-content,.cds--modal--slug .cds--modal-content.cds--modal-scroll-content,:host(cds-modal[has-scrolling-content]) .cds--modal--decorator .cds--modal-content::slotted(cds-modal-body),:host(cds-modal[has-scrolling-content]) .cds--modal--decorator :host(cds-modal-body)::slotted(cds-modal-body),:host(cds-modal[has-scrolling-content]) .cds--modal--slug .cds--modal-content::slotted(cds-modal-body),:host(cds-modal[has-scrolling-content]) .cds--modal--slug :host(cds-modal-body)::slotted(cds-modal-body){-webkit-mask-image:linear-gradient(to bottom,var(--cds-layer) calc(100% - 80px),transparent calc(100% - 48px),transparent 100%),linear-gradient(to left,var(--cds-layer) 0,16px,transparent 16px),linear-gradient(to right,var(--cds-layer) 0,2px,transparent 2px),linear-gradient(to top,var(--cds-layer) 0,2px,transparent 2px);mask-image:linear-gradient(to bottom,var(--cds-layer) calc(100% - 80px),transparent calc(100% - 48px),transparent 100%),linear-gradient(to left,var(--cds-layer) 0,16px,transparent 16px),linear-gradient(to right,var(--cds-layer) 0,2px,transparent 2px),linear-gradient(to top,var(--cds-layer) 0,2px,transparent 2px)}.cds--modal--decorator .cds--modal-container-body>.cds--modal--inner__decorator>*,.cds--modal--slug .cds--modal-container-body>.cds--ai-label,.cds--modal--slug .cds--modal-container-body>.cds--slug,.cds--modal-header>.cds--ai-label:has(+.cds--modal-close-button,+:host(cds-modal-close-button)),.cds--modal-header>.cds--modal--inner__decorator:has(+.cds--modal-close-button,+:host(cds-modal-close-button))>*,.cds--modal-header>.cds--modal-close-button~.cds--ai-label,.cds--modal-header>.cds--modal-close-button~.cds--modal--inner__decorator>*,.cds--modal-header>.cds--modal-close-button~.cds--slug,.cds--modal-header>.cds--slug:has(+.cds--modal-close-button,+:host(cds-modal-close-button)),.cds--modal-header>:host(cds-modal-close-button)~.cds--ai-label,.cds--modal-header>:host(cds-modal-close-button)~.cds--modal--inner__decorator>*,.cds--modal-header>:host(cds-modal-close-button)~.cds--slug,:host(cds-modal-header)>.cds--ai-label:has(+.cds--modal-close-button,+:host(cds-modal-close-button)),:host(cds-modal-header)>.cds--modal--inner__decorator:has(+.cds--modal-close-button,+:host(cds-modal-close-button))>*,:host(cds-modal-header)>.cds--modal-close-button~.cds--ai-label,:host(cds-modal-header)>.cds--modal-close-button~.cds--modal--inner__decorator>*,:host(cds-modal-header)>.cds--modal-close-button~.cds--slug,:host(cds-modal-header)>.cds--slug:has(+.cds--modal-close-button,+:host(cds-modal-close-button)),:host(cds-modal-header)>:host(cds-modal-close-button)~.cds--ai-label,:host(cds-modal-header)>:host(cds-modal-close-button)~.cds--modal--inner__decorator>*,:host(cds-modal-header)>:host(cds-modal-close-button)~.cds--slug{inset-block-start:.625rem;inset-inline-end:3rem;position:absolute}.cds--modal-header>.cds--modal--inner__decorator:not(:has(.cds--ai-label))>*,:host(cds-modal-header)>.cds--modal--inner__decorator:not(:has(.cds--ai-label))>*{inset-block-start:1rem}.cds--modal-header>.cds--modal--inner__decorator:has(.cds--ai-label--revert)>*,:host(cds-modal-header)>.cds--modal--inner__decorator:has(.cds--ai-label--revert)>*{inset-block-start:1.475rem}.cds--modal--decorator .cds--modal-content--overflow-indicator,.cds--modal--decorator .cds--modal-content--overflow-indicator:before{display:none}@media (forced-colors:active),screen and (-ms-high-contrast:active){.cds--modal-close__icon{fill:ButtonText}.cds--modal-close:focus{color:Highlight;outline:1px solid Highlight}}:host(cds-modal[open]){opacity:1;transition:opacity .24s cubic-bezier(0,0,.3,1),visibility 0ms linear;visibility:inherit}:host(cds-modal[open]) .cds--modal-container{transform:translateZ(0);transition:transform .24s cubic-bezier(0,0,.3,1)}@media screen and (prefers-reduced-motion:reduce){:host(cds-modal[open]){transition:none}}:host(cds-modal[full-width]) ::slotted(cds-modal-body){margin:0;padding:0}:host(cds-modal-close-button){outline:none}:host(cds-modal-heading),:host(cds-modal-label){display:block}:host(cds-modal-body) ::slotted(cds-form-item){margin-block-end:1rem}:host(cds-modal-body) ::slotted(cds-select:last-of-type){padding-block-end:0}:host(cds-modal-body) ::slotted(:last-child){padding-block-end:2rem}:host(cds-modal-body-content){display:block;font-size:var(--cds-body-01-font-size,.875rem);font-weight:var(--cds-body-01-font-weight,400);letter-spacing:var(--cds-body-01-letter-spacing,.16px);line-height:var(--cds-body-01-line-height,1.42857);padding-inline-end:calc(20% - 2rem)}:host(cds-modal-body-content[description]){margin-block-end:1rem}:host(cds-modal-footer[has-three-buttons]) ::slotted(cds-modal-footer-button){flex:0 1 25%}:host(cds-modal-footer-button:first-of-type) .cds--btn{box-shadow:inherit}:host(cds-modal-footer-button) .cds--btn{block-size:100%;box-shadow:-.0625rem 0 0 0 var(--cds-button-separator,#e0e0e0);inline-size:100%;max-inline-size:none;padding-block:1rem 2rem}:host(cds-modal-footer-button) .cds--btn:focus{box-shadow:inset 0 0 0 1px var(--cds-focus,#0f62fe),inset 0 0 0 2px var(--cds-background,#fff)}:host(cds-modal-footer) ::slotted(cds-button),:host(cds-modal-footer-button){block-size:4rem;flex:0 1 50%;inline-size:50%;margin:0;max-inline-size:none}:host(cds-modal[ai-label]){background-color:var(--cds-ai-overlay,rgba(0,17,65,.5))}:host(cds-modal[ai-label]) .cds--modal-container{background:linear-gradient(to top,var(--cds-layer,var(--cds-ai-popover-background,#fff)) 0,var(--cds-ai-aura-start,rgba(69,137,255,.1)) 0,15%,var(--cds-ai-aura-end,hsla(0,0%,100%,0)) 50%) padding-box,linear-gradient(to top,var(--cds-layer,var(--cds-ai-popover-background,#fff)),var(--cds-layer,var(--cds-ai-popover-background,#fff))) padding-box,linear-gradient(to bottom,var(--cds-ai-border-start,rgba(166,200,255,.64)),var(--cds-ai-border-end,#78a9ff)) border-box,linear-gradient(to top,var(--cds-layer,var(--cds-ai-popover-background,#fff)),var(--cds-layer,var(--cds-ai-popover-background,#fff))) border-box;background-color:var(--cds-layer);border:1px solid transparent;box-shadow:inset 0 -80px 70px -65px var(--cds-ai-inner-shadow,rgba(69,137,255,.1)),0 24px 40px -24px var(--cds-ai-drop-shadow,rgba(15,98,254,.1))}:host(cds-modal[ai-label][has-footer]) .cds--modal-container{background:linear-gradient(to top,var(--cds-layer,var(--cds-ai-popover-background,#fff)) 64px,var(--cds-ai-aura-start,rgba(69,137,255,.1)) 64px,15%,var(--cds-ai-aura-end,hsla(0,0%,100%,0)) 50%) padding-box,linear-gradient(to top,var(--cds-layer,var(--cds-ai-popover-background,#fff)),var(--cds-layer,var(--cds-ai-popover-background,#fff))) padding-box,linear-gradient(to bottom,var(--cds-ai-border-start,rgba(166,200,255,.64)),var(--cds-ai-border-end,#78a9ff)) border-box,linear-gradient(to top,var(--cds-layer,var(--cds-ai-popover-background,#fff)),var(--cds-layer,var(--cds-ai-popover-background,#fff))) border-box;box-shadow:inset 0 -80px 0 -16px var(--cds-layer),inset 0 -160px 70px -65px var(--cds-ai-inner-shadow,rgba(69,137,255,.1)),0 24px 40px -24px var(--cds-ai-drop-shadow,rgba(15,98,254,.1))}:host(cds-modal[ai-label][has-scrolling-content]) ::slotted(cds-modal-body){-webkit-mask-image:linear-gradient(to bottom,var(--cds-layer) calc(100% - 80px),transparent calc(100% - 48px),transparent 100%),linear-gradient(to left,var(--cds-layer) 0,16px,transparent 16px),linear-gradient(to right,var(--cds-layer) 0,2px,transparent 2px),linear-gradient(to top,var(--cds-layer) 0,2px,transparent 2px);mask-image:linear-gradient(to bottom,var(--cds-layer) calc(100% - 80px),transparent calc(100% - 48px),transparent 100%),linear-gradient(to left,var(--cds-layer) 0,16px,transparent 16px),linear-gradient(to right,var(--cds-layer) 0,2px,transparent 2px),linear-gradient(to top,var(--cds-layer) 0,2px,transparent 2px)}:host(cds-modal[ai-label]) .cds--modal-content--overflow-indicator,:host(cds-modal[ai-label]) .cds--modal-content--overflow-indicator:before{display:none}:host(cds-modal-header) ::slotted(cds-ai-label),:host(cds-modal-header) ::slotted(cds-slug){inset-block-start:0;inset-inline-end:0;position:absolute}:host(cds-modal-header[close-button]) ::slotted(cds-ai-label),:host(cds-modal-header[close-button]) ::slotted(cds-slug){inset-block-start:.625rem;inset-inline-end:3rem;position:absolute}"]);

export { styles as default };
//# sourceMappingURL=modal.scss.js.map
