/**
 * Copyright IBM Corp. 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

import { __decorate } from 'tslib';
import { html } from 'lit';
import { property } from 'lit/decorators.js';
import { ifDefined } from 'lit/directives/if-defined.js';
import { prefix } from '../../globals/settings.js';
import CDSDropdownItem from '../dropdown/dropdown-item.js';
import styles from './multi-select.scss.js';
import { carbonElement } from '../../globals/decorators/carbon-element.js';

/**
 * @license
 *
 * Copyright IBM Corp. 2019, 2023
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
/**
 * Multi select item.
 *
 * @element cds-multi-select-item
 */
let CDSMultiSelectItem = class CDSMultiSelectItem extends CDSDropdownItem {
    constructor() {
        super(...arguments);
        /**
         * The `name` attribute for the `<input>` for selection.
         */
        this.selectionName = '';
    }
    render() {
        const { disabled, selected, selectionName, value } = this;
        return html `
      <div class="${prefix}--list-box__menu-item__option">
        <div class="${prefix}--form-item ${prefix}--checkbox-wrapper">
          <span
            value="${value}"
            name="${ifDefined(selectionName || undefined)}"
            class="${prefix}--checkbox-label"
            ?disabled=${disabled}
            data-contained-checkbox-state=${selected}
            ><slot></slot
          ></span>
        </div>
      </div>
    `;
    }
    /**
     * A selector that will return multi select.
     */
    static get selectorList() {
        return `${prefix}-multi-select`;
    }
};
CDSMultiSelectItem.styles = styles;
__decorate([
    property({ type: Boolean })
], CDSMultiSelectItem.prototype, "filtered", void 0);
__decorate([
    property({ attribute: 'selection-name' })
], CDSMultiSelectItem.prototype, "selectionName", void 0);
CDSMultiSelectItem = __decorate([
    carbonElement(`${prefix}-multi-select-item`)
], CDSMultiSelectItem);
var CDSMultiSelectItem$1 = CDSMultiSelectItem;

export { CDSMultiSelectItem$1 as default };
//# sourceMappingURL=multi-select-item.js.map
