/**
 * Copyright IBM Corp. 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

import { __decorate } from 'tslib';
import { prefix } from '../../globals/settings.js';
import CDSButton from '../button/button.js';
import styles from './actionable-notification.scss.js';
import { carbonElement } from '../../globals/decorators/carbon-element.js';

/**
 * @license
 *
 * Copyright IBM Corp. 2019, 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
/**
 * Actionable notification action button.
 *
 * @element cds-actionable-notification-button
 */
let CDSActionableNotificationButton = class CDSActionableNotificationButton extends CDSButton {
    update(changedProperties) {
        var _a;
        super.update(changedProperties);
        (_a = this.shadowRoot.getElementById('button')) === null || _a === void 0 ? void 0 : _a.classList.add(`${prefix}--actionable-notification__action-button`);
        this.setAttribute('size', 'sm');
    }
};
CDSActionableNotificationButton.styles = styles;
CDSActionableNotificationButton = __decorate([
    carbonElement(`${prefix}-actionable-notification-button`)
], CDSActionableNotificationButton);
var CDSActionableNotificationButton$1 = CDSActionableNotificationButton;

export { CDSActionableNotificationButton$1 as default };
//# sourceMappingURL=actionable-notification-button.js.map
