/**
 * Copyright IBM Corp. 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

import { __decorate } from 'tslib';
import { html } from 'lit';
import { property } from 'lit/decorators.js';
import { prefix } from '../../globals/settings.js';
import { carbonElement } from '../../globals/decorators/carbon-element.js';
import { NOTIFICATION_TYPE } from './defs.js';
import CDSInlineNotification from './inline-notification.js';
import styles from './toast-notification.scss.js';

/**
 * @license
 *
 * Copyright IBM Corp. 2019, 2023
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
/**
 * Toast notification.
 *
 * @element cds-toast-notification
 * @slot subtitle - The subtitle.
 * @slot title - The title.
 * @fires cds-notification-beingclosed
 *   The custom event fired before this notification is being closed upon a user gesture.
 *   Cancellation of this event stops the user-initiated action of closing this notification.
 * @fires cds-notification-closed - The custom event fired after this notification is closed upon a user gesture.
 */
let CDSToastNotification = class CDSToastNotification extends CDSInlineNotification {
    constructor() {
        super(...arguments);
        this._type = NOTIFICATION_TYPE.TOAST;
        /**
         * Specify the caption
         */
        this.caption = '';
    }
    _renderText() {
        const { caption, subtitle, title, _type: type } = this;
        return html `
      <div class="${prefix}--${type}-notification__details">
        <div class="${prefix}--${type}-notification__title">
          ${title}<slot name="title"></slot>
        </div>
        <div class="${prefix}--${type}-notification__subtitle">
          ${subtitle}<slot name="subtitle"></slot>
        </div>
        <div class="${prefix}--${type}-notification__caption">
          ${caption}<slot name="caption"></slot>
        </div>
        <slot></slot>
      </div>
    `;
    }
    render() {
        const { _type: type } = this;
        return html `
      ${this._renderIcon()}
      <div class="${prefix}--${type}-notification__details">
        ${this._renderText()}
      </div>
      ${this._renderButton()}
    `;
    }
};
CDSToastNotification.styles = styles; // `styles` here is a `CSSResult` generated by custom Vite loader
__decorate([
    property()
], CDSToastNotification.prototype, "caption", void 0);
CDSToastNotification = __decorate([
    carbonElement(`${prefix}-toast-notification`)
], CDSToastNotification);
var CDSToastNotification$1 = CDSToastNotification;

export { CDSToastNotification$1 as default };
//# sourceMappingURL=toast-notification.js.map
