/**
 * Copyright IBM Corp. 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

import { __decorate } from 'tslib';
import { LitElement, html } from 'lit';
import { property } from 'lit/decorators.js';
import { prefix } from '../../globals/settings.js';
import styles from './number-input.scss.js';
import { carbonElement } from '../../globals/decorators/carbon-element.js';

/**
 * @license
 *
 * Copyright IBM Corp. 2019, 2023
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
/**
 * Skeleton of number input.
 */
let CDSNumberInputSkeleton = class CDSNumberInputSkeleton extends LitElement {
    constructor() {
        super(...arguments);
        /**
         * `true` if the label should be hidden. Corresponds to the attribute with the same name.
         */
        this.hideLabel = false;
    }
    render() {
        const { hideLabel } = this;
        return html `
      ${!hideLabel &&
            html ` <span class="${prefix}--label ${prefix}--skeleton"></span> `}
      <div class="${prefix}--number ${prefix}--skeleton"></div>
    `;
    }
};
CDSNumberInputSkeleton.styles = styles;
__decorate([
    property({ type: Boolean, reflect: true, attribute: 'hide-label' })
], CDSNumberInputSkeleton.prototype, "hideLabel", void 0);
CDSNumberInputSkeleton = __decorate([
    carbonElement(`${prefix}-number-input-skeleton`)
], CDSNumberInputSkeleton);
var CDSNumberInputSkeleton$1 = CDSNumberInputSkeleton;

export { CDSNumberInputSkeleton$1 as default };
//# sourceMappingURL=number-input-skeleton.js.map
