/**
 * Copyright IBM Corp. 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

/**
 * @license
 *
 * Copyright IBM Corp. 2020, 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
/**
 * The alignment choices of popover.
 */
var POPOVER_ALIGNMENT;
(function (POPOVER_ALIGNMENT) {
    /**
     * Align the top position for the popover content.
     */
    POPOVER_ALIGNMENT["TOP"] = "top";
    /**
     * Align the top-left position for the popover content.
     *
     * @deprecated
     */
    POPOVER_ALIGNMENT["TOP_LEFT"] = "top-left";
    /**
     * Align the top right position for the popover content.
     *
     * @deprecated
     */
    POPOVER_ALIGNMENT["TOP_RIGHT"] = "top-right";
    /**
     * Align the top-start position for the popover content.
     */
    POPOVER_ALIGNMENT["TOP_START"] = "top-start";
    /**
     * Align the top end position for the popover content.
     */
    POPOVER_ALIGNMENT["TOP_END"] = "top-end";
    /**
     * Align the bottom position for the popover content.
     */
    POPOVER_ALIGNMENT["BOTTOM"] = "bottom";
    /**
     * Align the bottom left position for the popover content.
     *
     * @deprecated
     */
    POPOVER_ALIGNMENT["BOTTOM_LEFT"] = "bottom-left";
    /**
     * Align the bottom right position for the popover content.
     *
     * @deprecated
     */
    POPOVER_ALIGNMENT["BOTTOM_RIGHT"] = "bottom-right";
    /**
     * Align the bottom start position for the popover content.
     */
    POPOVER_ALIGNMENT["BOTTOM_START"] = "bottom-start";
    /**
     * Align the bottom end position for the popover content.
     */
    POPOVER_ALIGNMENT["BOTTOM_END"] = "bottom-end";
    /**
     * Align the left position for the popover content.
     */
    POPOVER_ALIGNMENT["LEFT"] = "left";
    /**
     * Align the left bottom position for the popover content.
     *
     * @deprecated
     */
    POPOVER_ALIGNMENT["LEFT_BOTTOM"] = "left-bottom";
    /**
     * Align the left top position for the popover content.
     *
     * @deprecated
     */
    POPOVER_ALIGNMENT["LEFT_TOP"] = "left-top";
    /**
     * Align the left start position for the popover content.
     */
    POPOVER_ALIGNMENT["LEFT_START"] = "left-start";
    /**
     * Align the left end position for the popover content.
     */
    POPOVER_ALIGNMENT["LEFT_END"] = "left-end";
    /**
     * Align the right position for the popover content.
     */
    POPOVER_ALIGNMENT["RIGHT"] = "right";
    /**
     * Align the right bottom position for the popover content.
     *
     * @deprecated
     */
    POPOVER_ALIGNMENT["RIGHT_BOTTOM"] = "right-bottom";
    /**
     * Align the right top position for the popover content.
     *
     * @deprecated
     */
    POPOVER_ALIGNMENT["RIGHT_TOP"] = "right-top";
    /**
     * Align the right start position for the popover content.
     */
    POPOVER_ALIGNMENT["RIGHT_START"] = "right-start";
    /**
     * Align the right end position for the popover content.
     */
    POPOVER_ALIGNMENT["RIGHT_END"] = "right-end";
})(POPOVER_ALIGNMENT || (POPOVER_ALIGNMENT = {}));

export { POPOVER_ALIGNMENT };
//# sourceMappingURL=defs.js.map
