/**
 * Copyright IBM Corp. 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

import { __decorate } from 'tslib';
import { LitElement, html } from 'lit';
import { property } from 'lit/decorators.js';
import { carbonElement } from '../../globals/decorators/carbon-element.js';
import { prefix } from '../../globals/settings.js';
import styles from './popover.scss.js';

/**
 * @license
 *
 * Copyright IBM Corp. 2019, 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
/**
 * Popover.
 *
 * @element cds-popover
 */
let CDSPopoverContent = class CDSPopoverContent extends LitElement {
    constructor() {
        super(...arguments);
        /**
         * Specify the popover alignment
         */
        this.align = '';
        /**
         * Specify whether a auto align functionality should be applied
         */
        this.autoalign = false;
        /**
         * Specify whether a dropShadow should be rendered
         */
        this.dropShadow = true;
        /**
         * Specify whether the component is currently open or closed
         */
        this.open = false;
        /**
         * Render the component using the tab tip variant
         */
        this.tabTip = false;
        /**
         * The shadow slot this popover content should be in.
         */
        this.slot = 'content';
    }
    render() {
        if (this.autoalign) {
            return html `
        <span class="${prefix}--popover-content">
          <slot> </slot>
          <span class="${prefix}--popover-caret"></span>
        </span>
      `;
        }
        else {
            return html `
        <span class="${prefix}--popover-content">
          <slot> </slot>
        </span>
        <span class="${prefix}--popover-caret"></span>
      `;
        }
    }
};
CDSPopoverContent.styles = styles; // `styles` here is a `CSSResult` generated by custom Vite loader
__decorate([
    property({ reflect: true, type: String })
], CDSPopoverContent.prototype, "align", void 0);
__decorate([
    property({ type: Boolean, reflect: true })
], CDSPopoverContent.prototype, "autoalign", void 0);
__decorate([
    property({ type: Boolean, reflect: true })
], CDSPopoverContent.prototype, "caret", void 0);
__decorate([
    property({ type: Boolean, reflect: true })
], CDSPopoverContent.prototype, "dropShadow", void 0);
__decorate([
    property({ type: Boolean, reflect: true })
], CDSPopoverContent.prototype, "open", void 0);
__decorate([
    property({ type: Boolean, reflect: true })
], CDSPopoverContent.prototype, "tabTip", void 0);
__decorate([
    property({ reflect: true })
], CDSPopoverContent.prototype, "slot", void 0);
CDSPopoverContent = __decorate([
    carbonElement(`${prefix}-popover-content`)
], CDSPopoverContent);
var CDSPopoverContent$1 = CDSPopoverContent;

export { CDSPopoverContent$1 as default };
//# sourceMappingURL=popover-content.js.map
