/**
 * Copyright IBM Corp. 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

import { __decorate } from 'tslib';
import { LitElement, html } from 'lit';
import { property } from 'lit/decorators.js';
import { prefix } from '../../globals/settings.js';
import { forEach } from '../../globals/internal/collection-helpers.js';
import styles from './progress-indicator.scss.js';
import { carbonElement } from '../../globals/decorators/carbon-element.js';

/**
 * @license
 *
 * Copyright IBM Corp. 2019, 2023
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
/**
 * Skeleton of progress indicator.
 */
let CDSProgressIndicatorSkeleton = class CDSProgressIndicatorSkeleton extends LitElement {
    constructor() {
        super(...arguments);
        /**
         * `true` if the progress indicator should be vertical. Corresponds to the attribute with the same name.
         */
        this.vertical = false;
    }
    updated(changedProperties) {
        if (changedProperties.has('vertical')) {
            // Propagate `vertical` attribute to descendants until `:host-context()` gets supported in all major browsers
            forEach(this.querySelectorAll(this.constructor.selectorStep), (item) => {
                item.vertical = this.vertical;
            });
        }
    }
    render() {
        return html `<slot></slot>`;
    }
    /**
     * A selector that will return progress steps.
     */
    static get selectorStep() {
        return `${prefix}-progress-step-skeleton`;
    }
};
CDSProgressIndicatorSkeleton.styles = styles;
__decorate([
    property({ type: Boolean, reflect: true })
], CDSProgressIndicatorSkeleton.prototype, "vertical", void 0);
CDSProgressIndicatorSkeleton = __decorate([
    carbonElement(`${prefix}-progress-indicator-skeleton`)
], CDSProgressIndicatorSkeleton);
var CDSProgressIndicatorSkeleton$1 = CDSProgressIndicatorSkeleton;

export { CDSProgressIndicatorSkeleton$1 as default };
//# sourceMappingURL=progress-indicator-skeleton.js.map
