/**
 * Copyright IBM Corp. 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

import { __decorate } from 'tslib';
import { LitElement, html } from 'lit';
import { property } from 'lit/decorators.js';
import { prefix } from '../../globals/settings.js';
import { forEach } from '../../globals/internal/collection-helpers.js';
import styles from './progress-indicator.scss.js';
import { carbonElement } from '../../globals/decorators/carbon-element.js';

/**
 * @license
 *
 * Copyright IBM Corp. 2019, 2023
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
/**
 * Progress indicator.
 *
 * @element cds-progress-indicator
 */
let CDSProgressIndicator = class CDSProgressIndicator extends LitElement {
    constructor() {
        super(...arguments);
        /**
         * Determines whether or not the progress indicator should be rendered
         * vertically.
         */
        this.vertical = false;
        /**
         * Specify whether the progress steps should be split equally in size in the
         * div
         */
        this.spaceEqually = false;
    }
    connectedCallback() {
        if (!this.hasAttribute('role')) {
            this.setAttribute('role', 'list');
        }
        super.connectedCallback();
    }
    updated(changedProperties) {
        const spacingValue = this.vertical ? false : this.spaceEqually;
        if (changedProperties.has('vertical')) {
            // Propagate `vertical` attribute to descendants until
            // `:host-context()` gets supported in all major browsers
            forEach(this.querySelectorAll(this.constructor.selectorStep), (item) => {
                item.vertical = this.vertical;
                item.spaceEqually = spacingValue;
            });
        }
        if (changedProperties.has('spaceEqually')) {
            // Propagate `spaceEqually` attribute to descendants until
            // `:host-context()` gets supported in all major browsers
            forEach(this.querySelectorAll(this.constructor.selectorStep), (item) => {
                item.spaceEqually = spacingValue;
            });
        }
    }
    render() {
        return html `<slot></slot>`;
    }
    /**
     * A selector that will return progress steps.
     */
    static get selectorStep() {
        return `${prefix}-progress-step`;
    }
};
CDSProgressIndicator.styles = styles;
__decorate([
    property({ type: Boolean, reflect: true })
], CDSProgressIndicator.prototype, "vertical", void 0);
__decorate([
    property({ type: Boolean, reflect: true, attribute: 'space-equally' })
], CDSProgressIndicator.prototype, "spaceEqually", void 0);
CDSProgressIndicator = __decorate([
    carbonElement(`${prefix}-progress-indicator`)
], CDSProgressIndicator);
var CDSProgressIndicator$1 = CDSProgressIndicator;

export { CDSProgressIndicator$1 as default };
//# sourceMappingURL=progress-indicator.js.map
