/**
 * Copyright IBM Corp. 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

import { __decorate } from 'tslib';
import { LitElement, html } from 'lit';
import { property } from 'lit/decorators.js';
import { prefix } from '../../globals/settings.js';
import styles from './progress-indicator.scss.js';
import CircleDash from '../../icons/circle-dash/16';
import '../skeleton-text/skeleton-text.js';
import { carbonElement } from '../../globals/decorators/carbon-element.js';

/**
 * @license
 *
 * Copyright IBM Corp. 2019, 2023
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
/**
 * Skeleton of progress step.
 */
let CDSProgressStepSkeleton = class CDSProgressStepSkeleton extends LitElement {
    constructor() {
        super(...arguments);
        /**
         * `true` if the progress indicator should be vertical. Corresponds to the attribute with the same name.
         */
        this.vertical = false;
    }
    render() {
        return html `
      <div
        class="${prefix}--progress-step-button ${prefix}--progress-step-button--unclickable">
        ${CircleDash()}
        <p class="${prefix}--progress-label">
          <cds-skeleton-text width="40px" linecount="1"></cds-skeleton-text>
        </p>
        <span class="${prefix}--progress-line"></span>
      </div>
    `;
    }
};
CDSProgressStepSkeleton.styles = styles;
__decorate([
    property({ type: Boolean, reflect: true })
], CDSProgressStepSkeleton.prototype, "vertical", void 0);
CDSProgressStepSkeleton = __decorate([
    carbonElement(`${prefix}-progress-step-skeleton`)
], CDSProgressStepSkeleton);
var CDSProgressStepSkeleton$1 = CDSProgressStepSkeleton;

export { CDSProgressStepSkeleton$1 as default };
//# sourceMappingURL=progress-step-skeleton.js.map
