/**
 * Copyright IBM Corp. 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

import { __decorate } from 'tslib';
import { LitElement, html } from 'lit';
import { prefix } from '../../globals/settings.js';
import styles from './radio-button.scss.js';
import { carbonElement } from '../../globals/decorators/carbon-element.js';

/**
 * @license
 *
 * Copyright IBM Corp. 2019, 2023
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
/**
 * Skeleton of radio button.
 */
let CDSRadioButtonSkeleton = class CDSRadioButtonSkeleton extends LitElement {
    render() {
        return html `
      <div class="${prefix}--radio-button ${prefix}--skeleton"></div>
      <span class="${prefix}--radio-button__label ${prefix}--skeleton"></span>
    `;
    }
};
CDSRadioButtonSkeleton.styles = styles;
CDSRadioButtonSkeleton = __decorate([
    carbonElement(`${prefix}-radio-button-skeleton`)
], CDSRadioButtonSkeleton);
var CDSRadioButtonSkeleton$1 = CDSRadioButtonSkeleton;

export { CDSRadioButtonSkeleton$1 as default };
//# sourceMappingURL=radio-button-skeleton.js.map
