/**
 * Copyright IBM Corp. 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

import { __decorate } from 'tslib';
import { LitElement, html } from 'lit';
import { property } from 'lit/decorators.js';
import { prefix } from '../../globals/settings.js';
import '../text-input/text-input.js';
import styles from './search.scss.js';
import { carbonElement } from '../../globals/decorators/carbon-element.js';
import { INPUT_SIZE } from '../text-input/defs.js';

/**
 * @license
 *
 * Copyright IBM Corp. 2019, 2023
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
/**
 * Skeleton of search.
 */
let CDSSearchSkeleton = class CDSSearchSkeleton extends LitElement {
    constructor() {
        super(...arguments);
        /**
         * The search box size. Corresponds to the attribute with the same name.
         */
        this.size = INPUT_SIZE.MEDIUM;
    }
    render() {
        return html `
      <span class="${prefix}--label"></span>
      <div class="${prefix}--search-input"></div>
    `;
    }
};
CDSSearchSkeleton.styles = styles;
__decorate([
    property({ reflect: true })
], CDSSearchSkeleton.prototype, "size", void 0);
CDSSearchSkeleton = __decorate([
    carbonElement(`${prefix}-search-skeleton`)
], CDSSearchSkeleton);
var CDSSearchSkeleton$1 = CDSSearchSkeleton;

export { CDSSearchSkeleton$1 as default };
//# sourceMappingURL=search-skeleton.js.map
