/**
 * Copyright IBM Corp. 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

import { __decorate } from 'tslib';
import { LitElement } from 'lit';
import { property } from 'lit/decorators.js';
import { prefix } from '../../globals/settings.js';
import { carbonElement } from '../../globals/decorators/carbon-element.js';

/**
 * @license
 *
 * Copyright IBM Corp. 2020, 2023
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
/**
 * An option group in select box.
 *
 * @element cds-select-item-group
 */
let CDSSelectItemGroup = class CDSSelectItemGroup extends LitElement {
    constructor() {
        super(...arguments);
        /**
         * `true` to disable this option.
         */
        this.disabled = false;
        /**
         * The label.
         */
        this.label = '';
    }
};
__decorate([
    property({ type: Boolean, reflect: true })
], CDSSelectItemGroup.prototype, "disabled", void 0);
__decorate([
    property({ reflect: true })
], CDSSelectItemGroup.prototype, "label", void 0);
CDSSelectItemGroup = __decorate([
    carbonElement(`${prefix}-select-item-group`)
], CDSSelectItemGroup);
var CDSSelectItemGroup$1 = CDSSelectItemGroup;

export { CDSSelectItemGroup$1 as default };
//# sourceMappingURL=select-item-group.js.map
