/**
 * Copyright IBM Corp. 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

import { __decorate } from 'tslib';
import { LitElement } from 'lit';
import { property } from 'lit/decorators.js';
import { prefix } from '../../globals/settings.js';
import { carbonElement } from '../../globals/decorators/carbon-element.js';

/**
 * @license
 *
 * Copyright IBM Corp. 2020, 2023
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
/**
 * An option in select box.
 *
 * @element cds-select-item
 */
let CDSSelectItem = class CDSSelectItem extends LitElement {
    constructor() {
        super(...arguments);
        /**
         * `true` to disable this option.
         */
        this.disabled = false;
        /**
         * The label. If this is not specified, the child text content is used.
         */
        this.label = '';
        /**
         * `true` to select this option.
         */
        this.selected = false;
        /**
         * The value.
         */
        this.value = '';
    }
};
__decorate([
    property({ type: Boolean, reflect: true })
], CDSSelectItem.prototype, "disabled", void 0);
__decorate([
    property({ reflect: true })
], CDSSelectItem.prototype, "label", void 0);
__decorate([
    property({ type: Boolean, reflect: true })
], CDSSelectItem.prototype, "selected", void 0);
__decorate([
    property({ reflect: true })
], CDSSelectItem.prototype, "value", void 0);
CDSSelectItem = __decorate([
    carbonElement(`${prefix}-select-item`)
], CDSSelectItem);
var CDSSelectItem$1 = CDSSelectItem;

export { CDSSelectItem$1 as default };
//# sourceMappingURL=select-item.js.map
