/**
 * Copyright IBM Corp. 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

import { __decorate } from 'tslib';
import { LitElement, html } from 'lit';
import { property } from 'lit/decorators.js';
import { carbonElement } from '../../globals/decorators/carbon-element.js';
import { prefix } from '../../globals/settings.js';
import styles from './select.scss.js';

/**
 * @license
 *
 * Copyright IBM Corp. 2019, 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
/**
 * Skeleton of number input.
 */
let CDSSelectSkeleton = class CDSSelectSkeleton extends LitElement {
    constructor() {
        super(...arguments);
        /**
         * `true` if the label should be hidden. Corresponds to the attribute with the same name.
         */
        this.hideLabel = false;
    }
    render() {
        const { hideLabel } = this;
        return html `
      ${!hideLabel &&
            html ` <span class="${prefix}--label ${prefix}--skeleton"></span> `}
      <div class="${prefix}--select ${prefix}--skeleton"></div>
    `;
    }
};
CDSSelectSkeleton.styles = styles;
__decorate([
    property({ type: Boolean, reflect: true, attribute: 'hide-label' })
], CDSSelectSkeleton.prototype, "hideLabel", void 0);
CDSSelectSkeleton = __decorate([
    carbonElement(`${prefix}-select-skeleton`)
], CDSSelectSkeleton);
var CDSSelectSkeleton$1 = CDSSelectSkeleton;

export { CDSSelectSkeleton$1 as default };
//# sourceMappingURL=select-skeleton.js.map
