/**
 * Copyright IBM Corp. 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

import { css } from 'lit';

var styles = css([".cds--layer-one,:root{--cds-layer:var(--cds-layer-01,#f4f4f4);--cds-layer-active:var(--cds-layer-active-01,#c6c6c6);--cds-layer-hover:var(--cds-layer-hover-01,#e8e8e8);--cds-layer-selected:var(--cds-layer-selected-01,#e0e0e0);--cds-layer-selected-hover:var(--cds-layer-selected-hover-01,#d1d1d1);--cds-layer-accent:var(--cds-layer-accent-01,#e0e0e0);--cds-layer-accent-hover:var(--cds-layer-accent-hover-01,#d1d1d1);--cds-layer-accent-active:var(--cds-layer-accent-active-01,#a8a8a8);--cds-field:var(--cds-field-01,#f4f4f4);--cds-field-hover:var(--cds-field-hover-01,#e8e8e8);--cds-border-subtle:var(--cds-border-subtle-00,#e0e0e0);--cds-border-subtle-selected:var(--cds-border-subtle-selected-01,#c6c6c6);--cds-border-strong:var(--cds-border-strong-01,#8d8d8d);--cds-border-tile:var(--cds-border-tile-01,#c6c6c6)}.cds--layer-two{--cds-layer:var(--cds-layer-02,#fff);--cds-layer-active:var(--cds-layer-active-02,#c6c6c6);--cds-layer-hover:var(--cds-layer-hover-02,#e8e8e8);--cds-layer-selected:var(--cds-layer-selected-02,#e0e0e0);--cds-layer-selected-hover:var(--cds-layer-selected-hover-02,#d1d1d1);--cds-layer-accent:var(--cds-layer-accent-02,#e0e0e0);--cds-layer-accent-hover:var(--cds-layer-accent-hover-02,#d1d1d1);--cds-layer-accent-active:var(--cds-layer-accent-active-02,#a8a8a8);--cds-field:var(--cds-field-02,#fff);--cds-field-hover:var(--cds-field-hover-02,#e8e8e8);--cds-border-subtle:var(--cds-border-subtle-01,#c6c6c6);--cds-border-subtle-selected:var(--cds-border-subtle-selected-02,#c6c6c6);--cds-border-strong:var(--cds-border-strong-02,#8d8d8d);--cds-border-tile:var(--cds-border-tile-02,#a8a8a8)}.cds--layer-three{--cds-layer:var(--cds-layer-03,#f4f4f4);--cds-layer-active:var(--cds-layer-active-03,#c6c6c6);--cds-layer-hover:var(--cds-layer-hover-03,#e8e8e8);--cds-layer-selected:var(--cds-layer-selected-03,#e0e0e0);--cds-layer-selected-hover:var(--cds-layer-selected-hover-03,#d1d1d1);--cds-layer-accent:var(--cds-layer-accent-03,#e0e0e0);--cds-layer-accent-hover:var(--cds-layer-accent-hover-03,#d1d1d1);--cds-layer-accent-active:var(--cds-layer-accent-active-03,#a8a8a8);--cds-field:var(--cds-field-03,#f4f4f4);--cds-field-hover:var(--cds-field-hover-03,#e8e8e8);--cds-border-subtle:var(--cds-border-subtle-02,#e0e0e0);--cds-border-subtle-selected:var(--cds-border-subtle-selected-03,#c6c6c6);--cds-border-strong:var(--cds-border-strong-03,#8d8d8d);--cds-border-tile:var(--cds-border-tile-03,#c6c6c6)}@keyframes cds--hide-feedback{0%{opacity:1;visibility:inherit}to{opacity:0;visibility:hidden}}@keyframes cds--show-feedback{0%{opacity:0;visibility:hidden}to{opacity:1;visibility:inherit}}@keyframes cds--skeleton{0%{opacity:.3;transform:scaleX(0);transform-origin:left}20%{opacity:1;transform:scaleX(1);transform-origin:left}28%{transform:scaleX(1);transform-origin:right}51%{transform:scaleX(0);transform-origin:right}58%{transform:scaleX(0);transform-origin:right}82%{transform:scaleX(1);transform-origin:right}83%{transform:scaleX(1);transform-origin:left}96%{transform:scaleX(0);transform-origin:left}to{opacity:.3;transform:scaleX(0);transform-origin:left}}input:-webkit-autofill,input:-webkit-autofill:focus,input:-webkit-autofill:hover,textarea:-webkit-autofill,textarea:-webkit-autofill:focus,textarea:-webkit-autofill:hover{box-shadow:0 0 0 1000px var(--cds-field) inset;-webkit-text-fill-color:var(--cds-text-primary,#161616)}.cds--fieldset{border:0;box-sizing:border-box;font-family:inherit;font-size:100%;margin:0;padding:0;vertical-align:baseline}.cds--fieldset *,.cds--fieldset :after,.cds--fieldset :before{box-sizing:inherit}.cds--form-item{align-items:flex-start;display:flex;flex:1 1 auto;flex-direction:column;font-size:var(--cds-body-compact-01-font-size,.875rem);font-weight:var(--cds-body-compact-01-font-weight,400);letter-spacing:var(--cds-body-compact-01-letter-spacing,.16px);line-height:var(--cds-body-compact-01-line-height,1.28572)}.cds--label{color:var(--cds-text-secondary,#525252);display:inline-block;font-size:var(--cds-label-01-font-size,.75rem);font-weight:var(--cds-label-01-font-weight,400);font-weight:400;letter-spacing:var(--cds-label-01-letter-spacing,.32px);line-height:var(--cds-label-01-line-height,1.33333);line-height:1rem;margin-block-end:.5rem;vertical-align:baseline}.cds--label html{font-size:100%}.cds--label body{font-family:IBM Plex Sans,system-ui,-apple-system,BlinkMacSystemFont,\\.SFNSText-Regular,sans-serif;font-weight:400;-moz-osx-font-smoothing:grayscale;-webkit-font-smoothing:antialiased;text-rendering:optimizeLegibility}.cds--label code{font-family:IBM Plex Mono,system-ui,-apple-system,BlinkMacSystemFont,\\.SFNSText-Regular,monospace}.cds--label strong{font-weight:600}.cds--label .cds--toggletip-label{font-size:var(--cds-label-01-font-size,.75rem);font-weight:var(--cds-label-01-font-weight,400);letter-spacing:var(--cds-label-01-letter-spacing,.32px);line-height:var(--cds-label-01-line-height,1.33333)}.cds--label--no-margin{margin-block-end:0}.cds--label+.cds--tooltip{inset-block-start:.2rem;inset-inline-start:.5rem;position:relative}.cds--label+.cds--tooltip .cds--tooltip__trigger{align-items:center;-webkit-appearance:none;-moz-appearance:none;appearance:none;background:none;border:0;box-sizing:border-box;cursor:pointer;display:inline-block;display:flex;font-family:inherit;font-size:100%;font-size:var(--cds-label-01-font-size,.75rem);font-weight:var(--cds-label-01-font-weight,400);inline-size:100%;justify-content:center;letter-spacing:var(--cds-label-01-letter-spacing,.32px);line-height:var(--cds-label-01-line-height,1.33333);margin:0;padding:0;text-align:start;vertical-align:baseline}.cds--label+.cds--tooltip .cds--tooltip__trigger *,.cds--label+.cds--tooltip .cds--tooltip__trigger :after,.cds--label+.cds--tooltip .cds--tooltip__trigger :before{box-sizing:inherit}.cds--label+.cds--tooltip .cds--tooltip__trigger::-moz-focus-inner{border:0}.cds--label+.cds--tooltip .cds--tooltip__trigger:focus{outline:1px solid var(--cds-focus,#0f62fe)}.cds--label+.cds--tooltip .cds--tooltip__trigger svg{fill:var(--cds-icon-secondary,#525252)}.cds--label+.cds--tooltip .cds--tooltip__trigger svg :hover{fill:var(--cds-icon-primary,#161616)}.cds--label+.cds--toggletip{inset-block-start:.2rem;inset-inline-start:.5rem}.cds--label.cds--skeleton{background:var(--cds-skeleton-background,#e8e8e8);block-size:.875rem;border:none;box-shadow:none;inline-size:4.6875rem;padding:0;pointer-events:none;position:relative}.cds--label.cds--skeleton:active,.cds--label.cds--skeleton:focus,.cds--label.cds--skeleton:hover{border:none;cursor:default;outline:none}.cds--label.cds--skeleton:before{animation:cds--skeleton 3s ease-in-out infinite;background:var(--cds-skeleton-element,#c6c6c6);block-size:100%;content:\"\";inline-size:100%;inset-inline-start:0;position:absolute;will-change:transform-origin,transform,opacity}@media (prefers-reduced-motion:reduce){.cds--label.cds--skeleton:before{animation:none}}input[type=number]{font-family:IBM Plex Sans,system-ui,-apple-system,BlinkMacSystemFont,\\.SFNSText-Regular,sans-serif}.cds--combo-box[data-invalid]:not(.cds--multi-select--selected) .cds--text-input:not(:focus),.cds--list-box[data-invalid]:not(.cds--multi-select--invalid--focused,.cds--combo-box--invalid--focused),.cds--number[data-invalid] input[type=number]:not(:focus),.cds--select-input__wrapper[data-invalid] .cds--select-input:not(:focus),.cds--text-area__wrapper[data-invalid]>.cds--text-area--invalid:not(:focus),.cds--text-input__field-wrapper[data-invalid]>.cds--text-input--invalid:not(:focus),input[data-invalid]:not(:focus){outline:2px solid var(--cds-support-error,#da1e28);outline-offset:-2px}@media screen and (prefers-contrast){.cds--combo-box[data-invalid]:not(.cds--multi-select--selected) .cds--text-input:not(:focus),.cds--list-box[data-invalid]:not(.cds--multi-select--invalid--focused,.cds--combo-box--invalid--focused),.cds--number[data-invalid] input[type=number]:not(:focus),.cds--select-input__wrapper[data-invalid] .cds--select-input:not(:focus),.cds--text-area__wrapper[data-invalid]>.cds--text-area--invalid:not(:focus),.cds--text-input__field-wrapper[data-invalid]>.cds--text-input--invalid:not(:focus),input[data-invalid]:not(:focus){outline-style:dotted}}.cds--date-picker-input__wrapper--invalid~.cds--form-requirement,.cds--date-picker-input__wrapper--warn~.cds--form-requirement,.cds--date-picker-input__wrapper~.cds--form-requirement,.cds--list-box--warning~.cds--form-requirement,.cds--list-box[data-invalid]~.cds--form-requirement,.cds--number[data-invalid] .cds--number__input-wrapper~.cds--form-requirement,.cds--number__input-wrapper--warning~.cds--form-requirement,.cds--select--warning .cds--select-input__wrapper~.cds--form-requirement,.cds--select-input__wrapper[data-invalid]~.cds--form-requirement,.cds--text-area__wrapper--warn~.cds--form-requirement,.cds--text-area__wrapper[data-invalid]~.cds--form-requirement,.cds--text-input__field-wrapper--warning>.cds--text-input~.cds--form-requirement,.cds--text-input__field-wrapper--warning~.cds--form-requirement,.cds--text-input__field-wrapper[data-invalid]~.cds--form-requirement,.cds--time-picker--invalid~.cds--form-requirement,.cds--time-picker--warning~.cds--form-requirement,.cds--time-picker[data-invalid]~.cds--form-requirement,input[data-invalid]~.cds--form-requirement{display:block;font-weight:400;max-block-size:12.5rem;overflow:visible}.cds--date-picker-input__wrapper--invalid~.cds--form-requirement,.cds--date-picker-input__wrapper~.cds--form-requirement,.cds--list-box[data-invalid]~.cds--form-requirement,.cds--number[data-invalid] .cds--number__input-wrapper~.cds--form-requirement,.cds--select-input__wrapper[data-invalid]~.cds--form-requirement,.cds--text-area__wrapper[data-invalid]~.cds--form-requirement,.cds--text-input__field-wrapper[data-invalid]~.cds--form-requirement,.cds--time-picker--invalid~.cds--form-requirement,.cds--time-picker[data-invalid]~.cds--form-requirement,input[data-invalid]~.cds--form-requirement{color:var(--cds-text-error,#da1e28)}.cds--form--fluid .cds--text-input__field-wrapper--warning,.cds--form--fluid .cds--text-input__field-wrapper[data-invalid]{display:block}.cds--form--fluid input[data-invalid]{outline:none}.cds--form--fluid .cds--form-requirement{margin:0;padding:.5rem 2.5rem .5rem 1rem}input:not(output,[data-invalid]):-moz-ui-invalid{box-shadow:none}.cds--form-requirement{display:none;font-size:var(--cds-label-01-font-size,.75rem);font-weight:var(--cds-label-01-font-weight,400);letter-spacing:var(--cds-label-01-letter-spacing,.32px);line-height:var(--cds-label-01-line-height,1.33333);margin:.25rem 0 0;max-block-size:0;overflow:hidden}.cds--form-requirement html{font-size:100%}.cds--form-requirement body{font-family:IBM Plex Sans,system-ui,-apple-system,BlinkMacSystemFont,\\.SFNSText-Regular,sans-serif;font-weight:400;-moz-osx-font-smoothing:grayscale;-webkit-font-smoothing:antialiased;text-rendering:optimizeLegibility}.cds--form-requirement code{font-family:IBM Plex Mono,system-ui,-apple-system,BlinkMacSystemFont,\\.SFNSText-Regular,monospace}.cds--form-requirement strong{font-weight:600}.cds--select--inline .cds--form__helper-text{margin-block-start:0}.cds--form__helper-text{color:var(--cds-text-secondary,#525252);font-size:var(--cds-helper-text-01-font-size,.75rem);inline-size:100%;letter-spacing:var(--cds-helper-text-01-letter-spacing,.32px);line-height:var(--cds-helper-text-01-line-height,1.33333);margin-block-start:.25rem;opacity:1;z-index:0}.cds--form__helper-text--disabled,.cds--label--disabled,fieldset[disabled] .cds--form__helper-text,fieldset[disabled] .cds--label{color:var(--cds-text-disabled,hsla(0,0%,9%,.25))}.cds--select,:host(cds-select){align-items:flex-start;border:0;box-sizing:border-box;display:flex;flex-direction:column;font-family:inherit;font-size:100%;inline-size:100%;margin:0;padding:0;position:relative;vertical-align:baseline}.cds--select *,.cds--select :after,.cds--select :before,:host(cds-select) *,:host(cds-select) :after,:host(cds-select) :before{box-sizing:inherit}.cds--select-input__wrapper{align-items:center;display:flex;inline-size:100%;position:relative}.cds--select-input{-webkit-appearance:none;-moz-appearance:none;appearance:none;background-color:var(--cds-field);block-size:2.5rem;border:none;border-block-end:1px solid var(--cds-border-strong);border-radius:0;color:var(--cds-text-primary,#161616);cursor:pointer;display:block;font-family:inherit;font-size:var(--cds-body-compact-01-font-size,.875rem);font-weight:var(--cds-body-compact-01-font-weight,400);inline-size:100%;letter-spacing:var(--cds-body-compact-01-letter-spacing,.16px);line-height:var(--cds-body-compact-01-line-height,1.28572);opacity:1;outline:2px solid transparent;outline-offset:-2px;padding-block:0;padding-inline:1rem 3rem;text-overflow:ellipsis;transition:outline 70ms cubic-bezier(.2,0,.38,.9)}.cds--select-input:hover{background-color:var(--cds-field-hover)}.cds--select-input::-ms-expand{display:none}@document url-prefix(){.cds--select-input:-moz-focusring,.cds--select-input::-moz-focus-inner{background-image:none;color:transparent;text-shadow:0 0 0 #000}}.cds--select-input:focus{color:var(--cds-text-primary,#161616);outline:2px solid var(--cds-focus,#0f62fe);outline-offset:-2px}@media screen and (prefers-contrast){.cds--select-input:focus{outline-style:dotted}}.cds--select-input:disabled,.cds--select-input:hover:disabled{background-color:var(--cds-field);border-block-end-color:transparent;color:var(--cds-text-disabled,hsla(0,0%,9%,.25));cursor:not-allowed}.cds--select-input--sm{block-size:2rem;max-block-size:2rem}.cds--select-input--lg{block-size:3rem;max-block-size:3rem}.cds--select--disabled .cds--form__helper-text,.cds--select--disabled .cds--label,:host(cds-select[disabled]) .cds--form__helper-text,:host(cds-select[disabled]) .cds--label{color:var(--cds-text-disabled,hsla(0,0%,9%,.25))}.cds--select--warning .cds--select-input,.cds--select-input__wrapper[data-invalid] .cds--select-input{padding-inline-end:4rem}.cds--select-input:disabled~.cds--select__arrow{fill:var(--cds-icon-disabled,hsla(0,0%,9%,.25))}.cds--select--light .cds--select-input{background-color:var(--cds-field-02,#fff)}.cds--select--light .cds--select-input:hover{background-color:var(--cds-field-hover)}.cds--select--light .cds--select-input:disabled,.cds--select--light .cds--select-input:hover:disabled{background-color:var(--cds-field-02,#fff);color:var(--cds-text-disabled,hsla(0,0%,9%,.25));cursor:not-allowed}.cds--select__arrow{block-size:100%;position:absolute;fill:var(--cds-icon-primary,#161616);inset-block-start:0;inset-inline-end:1rem;pointer-events:none}@media screen and (-ms-high-contrast:active),screen and (prefers-contrast){.cds--select__arrow path{fill:ButtonText}}.cds--select__invalid-icon{inset-inline-end:2.5rem;position:absolute}.cds--select-input__wrapper[data-invalid] .cds--select-input~.cds--select__invalid-icon{fill:var(--cds-support-error,#da1e28)}.cds--select__invalid-icon--warning{fill:var(--cds-support-warning,#f1c21b)}.cds--select__invalid-icon--warning path[fill]{fill:#000;opacity:1}.cds--select-option,optgroup.cds--select-optgroup{background-color:var(--cds-layer-hover);color:var(--cds-text-primary,#161616)}.cds--select-option:disabled,optgroup.cds--select-optgroup:disabled{color:var(--cds-text-disabled,hsla(0,0%,9%,.25))}.cds--select--inline{align-items:center;display:flex;flex-direction:row}.cds--select--inline.cds--select--invalid .cds--form__helper-text,.cds--select--inline.cds--select--invalid .cds--label{align-self:flex-start;margin-block-start:.8125rem}.cds--select--inline .cds--form__helper-text{margin-block-end:0;margin-inline-start:.5rem}.cds--select--inline .cds--label{margin:0 .5rem 0 0;white-space:nowrap}.cds--select--inline .cds--select-input{background-color:transparent;border-block-end:none;color:var(--cds-text-primary,#161616);inline-size:auto;padding-inline:.5rem 2rem}.cds--select--inline .cds--select-input:focus,.cds--select--inline .cds--select-input:focus optgroup,.cds--select--inline .cds--select-input:focus option{background-color:var(--cds-background,#fff)}.cds--select--inline .cds--select-input[disabled],.cds--select--inline .cds--select-input[disabled]:hover{background-color:var(--cds-field)}.cds--select--inline .cds--select__arrow{inset-inline-end:.5rem}.cds--select--inline.cds--select--invalid .cds--select-input{padding-inline-end:3.5rem}.cds--select--inline.cds--select--invalid .cds--select-input~.cds--select__invalid-icon{inset-inline-end:2rem}.cds--select--inline .cds--select-input:disabled{color:var(--cds-text-disabled,hsla(0,0%,9%,.25));cursor:not-allowed}.cds--select--inline .cds--select-input:disabled~*{cursor:not-allowed}.cds--select--readonly .cds--select-input{background-color:transparent;border-block-end-color:var(--cds-border-subtle);cursor:default}.cds--select--readonly .cds--select__arrow{fill:var(--cds-icon-disabled,hsla(0,0%,9%,.25))}.cds--select.cds--skeleton{background:var(--cds-skeleton-background,#e8e8e8);block-size:2.5rem;border:none;box-shadow:none;inline-size:100%;padding:0;pointer-events:none;position:relative}.cds--select.cds--skeleton:active,.cds--select.cds--skeleton:focus,.cds--select.cds--skeleton:hover{border:none;cursor:default;outline:none}.cds--select.cds--skeleton:before{animation:cds--skeleton 3s ease-in-out infinite;background:var(--cds-skeleton-element,#c6c6c6);block-size:100%;content:\"\";inline-size:100%;inset-inline-start:0;position:absolute;will-change:transform-origin,transform,opacity}@media (prefers-reduced-motion:reduce){.cds--select.cds--skeleton:before{animation:none}}.cds--select.cds--skeleton .cds--select-input{display:none}.cds--select--decorator .cds--select__inner-wrapper--decorator>*,.cds--select--slug .cds--ai-label,.cds--select--slug .cds--slug{inset-block-start:50%;inset-inline-end:calc(2.5rem + 9px);margin-block-start:.03125rem;position:absolute;transform:translateY(-50%)}.cds--select--decorator .cds--select__inner-wrapper--decorator>:after,.cds--select--decorator .cds--select__inner-wrapper--decorator>:before,.cds--select--slug .cds--ai-label:after,.cds--select--slug .cds--ai-label:before,.cds--select--slug .cds--slug:after,.cds--select--slug .cds--slug:before{background-color:var(--cds-border-subtle-01,#c6c6c6);block-size:1rem;content:\"\";inline-size:.0625rem;position:absolute}.cds--select--decorator .cds--select__inner-wrapper--decorator>:before,.cds--select--slug .cds--ai-label:before,.cds--select--slug .cds--slug:before{display:none;inset-inline-start:calc(-.5rem - 1px)}.cds--select--decorator .cds--select__inner-wrapper--decorator>:after,.cds--select--slug .cds--ai-label:after,.cds--select--slug .cds--slug:after{display:block;inset-block-start:0;inset-inline-end:calc(-.5rem - 1px)}.cds--select--decorator .cds--select__inner-wrapper--decorator>.cds--ai-label--revert:before,.cds--select--slug .cds--ai-label--revert:before,.cds--select--slug .cds--slug--revert:before{inset-block-start:.5rem;inset-inline-start:0}.cds--select--decorator .cds--select__inner-wrapper--decorator>.cds--ai-label--revert,.cds--select--slug .cds--ai-label--revert{inset-inline-end:2.5625rem}.cds--select--decorator .cds--ai-label--revert:after,.cds--select--slug .cds--ai-label--revert:after,.cds--select--slug .cds--slug--revert:after{inset-block-start:.5rem;inset-inline-end:-1px}.cds--select--decorator .cds--select-input:has(~.cds--select__inner-wrapper--decorator),.cds--select--slug .cds--select-input:has(~.cds--ai-label),.cds--select--slug .cds--select-input:has(~.cds--slug){padding-inline-end:4rem}.cds--select--decorator:has(.cds--select__invalid-icon) .cds--select-input:has(~.cds--select__inner-wrapper--decorator),.cds--select--slug:has(.cds--select__invalid-icon) .cds--select-input:has(~.cds--ai-label),.cds--select--slug:has(.cds--select__invalid-icon) .cds--select-input:has(~.cds--slug){padding-inline-end:6rem}.cds--select--decorator .cds--select-input:has(~.cds--select__inner-wrapper--decorator .cds--ai-label):not(:has(~.cds--select__inner-wrapper--decorator .cds--ai-label--revert)),.cds--select--slug .cds--select-input:has(~.cds--ai-label):not(:has(~.cds--ai-label--revert)),.cds--select--slug .cds--select-input:has(~.cds--slug):not(:has(~.cds--slug--revert)){background-image:linear-gradient(0deg,var(--cds-ai-aura-start-sm,rgba(69,137,255,.16)) 0,15%,var(--cds-ai-aura-end,hsla(0,0%,100%,0)) 50%,transparent 100%);border-block-end-color:var(--cds-ai-border-strong,#4589ff)}.cds--select--decorator:has(.cds--select__invalid-icon) .cds--select__inner-wrapper--decorator>:before,.cds--select--slug:has(.cds--select__invalid-icon) .cds--ai-label:before,.cds--select--slug:has(.cds--select__invalid-icon) .cds--slug:before{display:block}.cds--select--decorator .cds--select-input__wrapper .cds--select-input~.cds--select__invalid-icon,.cds--select--slug .cds--select-input__wrapper .cds--select-input~.cds--select__invalid-icon,.cds--select--slug .cds--select-input__wrapper[data-invalid] .cds--select-input~.cds--select__invalid-icon{inset-inline-end:5rem}@media (forced-colors:active),screen and (-ms-high-contrast:active){.cds--select__arrow{fill:ButtonText}}:host(cds-select){outline:none}:host(cds-select) ::slotted(cds-ai-label),:host(cds-select) ::slotted(cds-slug){inset-block-start:50%;inset-inline-end:2.5rem;position:absolute}:host(cds-select) ::slotted(cds-ai-label:not([revert-active])),:host(cds-select) ::slotted(cds-slug:not([revert-active])){transform:translateY(-50%)}:host(cds-select[readonly]) select{pointer-events:none}:host(cds-select[inline][warn]) .cds--form__helper-text,:host(cds-select[inline][warn]) .cds--label{align-self:flex-start;margin-block-start:.8125rem}:host(cds-select[inline][warn]) select{padding-inline-end:3.5rem}:host(cds-select[inline][warn]) .cds--select__invalid-icon--warning{inset-inline-end:2rem}:host(cds-select[pagination]) .cds--label{margin:0}:host(cds-select[pagination]) .cds--select-input{padding:0 2.25rem 0 1rem}:host(cds-select[pagination]) .cds--select-input:focus{background-color:transparent}:host(cds-select[pagination]) .cds--select__arrow{inset-block-start:50%;transform:translate(-.5rem,-50%)}:host(cds-select[pagination][left-select]) .cds--select-input{border-inline-end:1px solid var(--cds-border-subtle)}:host(cds-select[invalid]) ::slotted(cds-ai-label),:host(cds-select[invalid]) ::slotted(cds-slug),:host(cds-select[warn]) ::slotted(cds-ai-label),:host(cds-select[warn]) ::slotted(cds-slug){inset-inline-end:4rem}"]);

export { styles as default };
//# sourceMappingURL=select.scss.js.map
