/**
 * Copyright IBM Corp. 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

import { __decorate } from 'tslib';
import { LitElement } from 'lit';
import { prefix } from '../../globals/settings.js';
import styles from './skeleton-icon.scss.js';
import { carbonElement } from '../../globals/decorators/carbon-element.js';

/**
 * @license
 *
 * Copyright IBM Corp. 2019, 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
/**
 * Skeleton icon.
 *
 * @element cds-skeleton-icon
 */
let CDSSkeletonIcon = class CDSSkeletonIcon extends LitElement {
};
CDSSkeletonIcon.styles = styles;
CDSSkeletonIcon = __decorate([
    carbonElement(`${prefix}-skeleton-icon`)
], CDSSkeletonIcon);
var CDSSkeletonIcon$1 = CDSSkeletonIcon;

export { CDSSkeletonIcon$1 as default };
//# sourceMappingURL=skeleton-icon.js.map
