/**
 * Copyright IBM Corp. 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

import { __decorate } from 'tslib';
import { classMap } from 'lit/directives/class-map.js';
import { LitElement, html } from 'lit';
import { property } from 'lit/decorators.js';
import { prefix } from '../../globals/settings.js';
import styles from './skeleton-placeholder.scss.js';
import { carbonElement } from '../../globals/decorators/carbon-element.js';

/**
 * @license
 *
 * Copyright IBM Corp. 2019, 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
/**
 * Skeleton placeholder.
 *
 * @element cds-skeleton-placeholder
 */
let CDSSkeletonPlaceholder = class CDSSkeletonPlaceholder extends LitElement {
    render() {
        var _a;
        let defaultClasses = {
            [`${prefix}--skeleton__placeholder`]: true,
        };
        if (this.optionalClasses) {
            const outputObject = {};
            (_a = this.optionalClasses) === null || _a === void 0 ? void 0 : _a.split(' ').forEach((element) => {
                outputObject[element] = true;
            });
            defaultClasses = Object.assign(Object.assign({}, defaultClasses), outputObject);
        }
        const classes = classMap(defaultClasses);
        return html ` <div class="${classes}"></div> `;
    }
};
CDSSkeletonPlaceholder.styles = styles;
__decorate([
    property({ reflect: true, attribute: 'optional-classes' })
], CDSSkeletonPlaceholder.prototype, "optionalClasses", void 0);
CDSSkeletonPlaceholder = __decorate([
    carbonElement(`${prefix}-skeleton-placeholder`)
], CDSSkeletonPlaceholder);
var CDSSkeletonPlaceholder$1 = CDSSkeletonPlaceholder;

export { CDSSkeletonPlaceholder$1 as default };
//# sourceMappingURL=skeleton-placeholder.js.map
