/**
 * Copyright IBM Corp. 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

import { __decorate } from 'tslib';
import { classMap } from 'lit/directives/class-map.js';
import { LitElement, html } from 'lit';
import { property } from 'lit/decorators.js';
import { prefix } from '../../globals/settings.js';
import { SKELETON_TEXT_TYPE } from './defs.js';
export { SKELETON_TEXT_TYPE } from './defs.js';
import styles from './skeleton-text.scss.js';
import { carbonElement } from '../../globals/decorators/carbon-element.js';

/**
 * @license
 *
 * Copyright IBM Corp. 2019, 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
function getRandomInt(min, max, n) {
    const randoms = [0.973051493507435, 0.15334737213558558, 0.5671034553053769];
    return Math.floor(randoms[n % 3] * (max - min + 1)) + min;
}
/**
 * Skeleton text.
 *
 * @element cds-skeleton-text
 */
let CDSSkeletonText = class CDSSkeletonText extends LitElement {
    constructor() {
        super(...arguments);
        /**
         * The type of skeleton text.
         */
        this.type = SKELETON_TEXT_TYPE.REGULAR;
        /**
         * width (in px or %) of single line of text or max-width of paragraph lines
         */
        this.width = '100%';
        /**
         * will generate multiple lines of text
         */
        this.paragraph = false;
        /**
         * the number of lines in a paragraph
         */
        this.lineCount = 3;
    }
    render() {
        const { optionalClasses, paragraph, lineCount, type, width } = this;
        let defaultClasses = {
            [`${prefix}--skeleton__text`]: true,
            [`${prefix}--skeleton__heading`]: type === SKELETON_TEXT_TYPE.HEADING,
        };
        if (optionalClasses) {
            const outputObject = {};
            optionalClasses === null || optionalClasses === void 0 ? void 0 : optionalClasses.split(' ').forEach((element) => {
                outputObject[element] = true;
            });
            defaultClasses = Object.assign(Object.assign({}, defaultClasses), outputObject);
        }
        const classes = classMap(defaultClasses);
        if (paragraph) {
            const widthNum = parseInt(this.width, 10);
            const widthPx = this.width.includes('px');
            const widthPercent = this.width.includes('%');
            const lines = [];
            for (let i = 0; i < lineCount; i++) {
                const randomWidth = (widthPercent && `${getRandomInt(0, 75, i)}px`) ||
                    (widthPx && `${getRandomInt(0, widthNum, i)}px`);
                const style = (widthPercent && `width: calc(${width} - ${randomWidth})`) ||
                    (widthPx && `width: ${randomWidth}`) ||
                    '';
                lines.push(html `<p class="${classes}" style="${style}"></p>`);
            }
            return lines;
        }
        return html `<p class="${classes}" style="width:${width}"></p>`;
    }
};
CDSSkeletonText.styles = styles;
__decorate([
    property({ reflect: true, attribute: 'optional-classes' })
], CDSSkeletonText.prototype, "optionalClasses", void 0);
__decorate([
    property({ reflect: true })
], CDSSkeletonText.prototype, "type", void 0);
__decorate([
    property({ reflect: true })
], CDSSkeletonText.prototype, "width", void 0);
__decorate([
    property({ type: Boolean, reflect: true })
], CDSSkeletonText.prototype, "paragraph", void 0);
__decorate([
    property({ type: Number, reflect: true })
], CDSSkeletonText.prototype, "lineCount", void 0);
CDSSkeletonText = __decorate([
    carbonElement(`${prefix}-skeleton-text`)
], CDSSkeletonText);
var CDSSkeletonText$1 = CDSSkeletonText;

export { CDSSkeletonText$1 as default };
//# sourceMappingURL=skeleton-text.js.map
