/**
 * Copyright IBM Corp. 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

import { __decorate } from 'tslib';
import { LitElement, html } from 'lit';
import { property } from 'lit/decorators.js';
import { prefix } from '../../globals/settings.js';
import { ifDefined } from 'lit/directives/if-defined.js';
import FocusMixin from '../../globals/mixins/focus.js';
import styles from './skip-to-content.scss.js';
import { carbonElement } from '../../globals/decorators/carbon-element.js';

/**
 * @license
 *
 * Copyright IBM Corp. 2020, 2023
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
/**
 * Skip-to-content link.
 *
 * @element cds-skip-to-content
 */
let CDSSkipToContent = class CDSSkipToContent extends FocusMixin(LitElement) {
    constructor() {
        super(...arguments);
        /**
         * The assistive text for the link,
         */
        this.linkAssisstiveText = 'Skip to main content';
    }
    connectedCallback() {
        if (!this.hasAttribute('role')) {
            this.setAttribute('role', 'navigation');
        }
        super.connectedCallback();
    }
    render() {
        const { linkAssisstiveText } = this;
        return html `
      <a class="${prefix}--skip-to-content" href="${ifDefined(this.href)}"
        ><slot>${linkAssisstiveText}</slot></a
      >
    `;
    }
    updated(changedProperties) {
        if (changedProperties.has('linkAssisstiveText')) {
            const { linkAssisstiveText } = this;
            this.setAttribute('aria-label', linkAssisstiveText);
        }
    }
};
CDSSkipToContent.shadowRootOptions = Object.assign(Object.assign({}, LitElement.shadowRootOptions), { delegatesFocus: true });
CDSSkipToContent.styles = styles; // `styles` here is a `CSSResult` generated by custom Vite loader
__decorate([
    property({ attribute: 'link-assistive-text' })
], CDSSkipToContent.prototype, "linkAssisstiveText", void 0);
__decorate([
    property()
], CDSSkipToContent.prototype, "href", void 0);
CDSSkipToContent = __decorate([
    carbonElement(`${prefix}-skip-to-content`)
], CDSSkipToContent);
var CDSSkipToContent$1 = CDSSkipToContent;

export { CDSSkipToContent$1 as default };
//# sourceMappingURL=skip-to-content.js.map
