/**
 * Copyright IBM Corp. 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

import { __decorate } from 'tslib';
import { LitElement, html } from 'lit';
import { prefix } from '../../globals/settings.js';
import styles from './slider.scss.js';
import { carbonElement } from '../../globals/decorators/carbon-element.js';

/**
 * @license
 *
 * Copyright IBM Corp. 2019, 2023
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
/**
 * Skeleton of slider.
 */
let CDSSliderSkeleton = class CDSSliderSkeleton extends LitElement {
    render() {
        return html `
      <span class="${prefix}--label ${prefix}--skeleton"></span>
      <div class="${prefix}--slider-container ${prefix}--skeleton">
        <span class="${prefix}--slider__range-label"></span>
        <div class="${prefix}--slider">
          <div class="${prefix}--slider__track"></div>
          <div class="${prefix}--slider__filled-track"></div>
          <div class="${prefix}--slider__thumb"></div>
        </div>
        <span class="${prefix}--slider__range-label"></span>
      </div>
    `;
    }
};
CDSSliderSkeleton.styles = styles;
CDSSliderSkeleton = __decorate([
    carbonElement(`${prefix}-slider-skeleton`)
], CDSSliderSkeleton);
var CDSSliderSkeleton$1 = CDSSliderSkeleton;

export { CDSSliderSkeleton$1 as default };
//# sourceMappingURL=slider-skeleton.js.map
