/**
 * Copyright IBM Corp. 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

import { __decorate } from 'tslib';
import { property } from 'lit/decorators.js';
import { prefix } from '../../globals/settings.js';
import CDSButton from '../button/button.js';
import styles from './slug.scss.js';
import { carbonElement } from '../../globals/decorators/carbon-element.js';

/**
 * @license
 *
 * Copyright IBM Corp. 2019, 2023
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
/**
 * Slug action button.
 *
 * @deprecated This component has been deprecated, please use the <cds-ai-label-action-button> component instead.
 * @element cds-slug-action-button
 */
let CDSSlugActionButton = class CDSSlugActionButton extends CDSButton {
    constructor() {
        super(...arguments);
        /**
         * The shadow slot this slug-action should be in.
         */
        this.slot = 'actions';
    }
};
CDSSlugActionButton.styles = styles;
__decorate([
    property({ reflect: true })
], CDSSlugActionButton.prototype, "slot", void 0);
CDSSlugActionButton = __decorate([
    carbonElement(`${prefix}-slug-action-button`)
], CDSSlugActionButton);
var CDSSlugActionButton$1 = CDSSlugActionButton;

export { CDSSlugActionButton$1 as default };
//# sourceMappingURL=slug-action-button.js.map
