/**
 * Copyright IBM Corp. 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

import { __decorate } from 'tslib';
import { LitElement, html } from 'lit';
import { prefix } from '../../globals/settings.js';
import styles from './structured-list.scss.js';
import { carbonElement } from '../../globals/decorators/carbon-element.js';

/**
 * @license
 *
 * Copyright IBM Corp. 2020, 2023
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
/**
 * Structured list cell.
 *
 * @element cds-structured-list-cell
 */
let CDSStructuredListCell = class CDSStructuredListCell extends LitElement {
    connectedCallback() {
        if (!this.hasAttribute('role')) {
            this.setAttribute('role', 'cell');
        }
        super.connectedCallback();
    }
    render() {
        return html ` <slot></slot> `;
    }
};
CDSStructuredListCell.styles = styles;
CDSStructuredListCell = __decorate([
    carbonElement(`${prefix}-structured-list-cell`)
], CDSStructuredListCell);
var CDSStructuredListCell$1 = CDSStructuredListCell;

export { CDSStructuredListCell$1 as default };
//# sourceMappingURL=structured-list-cell.js.map
