/**
 * Copyright IBM Corp. 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

import { __decorate } from 'tslib';
import { LitElement, html } from 'lit';
import { prefix } from '../../globals/settings.js';
import { carbonElement } from '../../globals/decorators/carbon-element.js';
import styles from './structured-list.scss.js';

/**
 * @license
 *
 * Copyright IBM Corp. 2019, 2023
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
/**
 * Structured list header.
 *
 * @element cds-structured-list-head
 */
let CDSStructuredListHeader = class CDSStructuredListHeader extends LitElement {
    connectedCallback() {
        if (!this.hasAttribute('role')) {
            this.setAttribute('role', 'rowgroup');
        }
        super.connectedCallback();
    }
    render() {
        return html ` <slot></slot> `;
    }
};
CDSStructuredListHeader.styles = styles;
CDSStructuredListHeader = __decorate([
    carbonElement(`${prefix}-structured-list-head`)
], CDSStructuredListHeader);
var CDSStructuredListHeader$1 = CDSStructuredListHeader;

export { CDSStructuredListHeader$1 as default };
//# sourceMappingURL=structured-list-head.js.map
