/**
 * Copyright IBM Corp. 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

import { __decorate } from 'tslib';
import { LitElement, html } from 'lit';
import { prefix } from '../../globals/settings.js';
import styles from './structured-list.scss.js';
import { carbonElement } from '../../globals/decorators/carbon-element.js';

/**
 * @license
 *
 * Copyright IBM Corp. 2019, 2023
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
/**
 * Skeleton of structured list header cell.
 */
let CDSStructuredListHeaderCellSkeleton = class CDSStructuredListHeaderCellSkeleton extends LitElement {
    render() {
        return html ` <span></span> `;
    }
};
CDSStructuredListHeaderCellSkeleton.styles = styles;
CDSStructuredListHeaderCellSkeleton = __decorate([
    carbonElement(`${prefix}-structured-list-header-cell-skeleton`)
], CDSStructuredListHeaderCellSkeleton);
var CDSStructuredListHeaderCellSkeleton$1 = CDSStructuredListHeaderCellSkeleton;

export { CDSStructuredListHeaderCellSkeleton$1 as default };
//# sourceMappingURL=structured-list-header-cell-skeleton.js.map
