/**
 * Copyright IBM Corp. 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

import { __decorate } from 'tslib';
import { LitElement, html } from 'lit';
import { prefix } from '../../globals/settings.js';
import styles from './structured-list.scss.js';
import { carbonElement } from '../../globals/decorators/carbon-element.js';

/**
 * @license
 *
 * Copyright IBM Corp. 2020, 2023
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
/**
 * Structured list header cell.
 *
 * @element cds-structured-list-header-cell
 */
let CDSStructuredListHeaderCell = class CDSStructuredListHeaderCell extends LitElement {
    connectedCallback() {
        if (!this.hasAttribute('role')) {
            this.setAttribute('role', 'columnheader');
        }
        super.connectedCallback();
    }
    render() {
        return html ` <slot></slot> `;
    }
};
CDSStructuredListHeaderCell.styles = styles;
CDSStructuredListHeaderCell = __decorate([
    carbonElement(`${prefix}-structured-list-header-cell`)
], CDSStructuredListHeaderCell);
var CDSStructuredListHeaderCell$1 = CDSStructuredListHeaderCell;

export { CDSStructuredListHeaderCell$1 as default };
//# sourceMappingURL=structured-list-header-cell.js.map
