/**
 * Copyright IBM Corp. 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

import { __decorate } from 'tslib';
import { LitElement, html } from 'lit';
import { property } from 'lit/decorators.js';
import { prefix } from '../../globals/settings.js';
import { carbonElement } from '../../globals/decorators/carbon-element.js';
import styles from './structured-list.scss.js';

/**
 * @license
 *
 * Copyright IBM Corp. 2019, 2023
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
/**
 * Structured list header row.
 *
 * @element cds-structured-list-header-row
 */
let CDSStructuredListHeaderRow = class CDSStructuredListHeaderRow extends LitElement {
    constructor() {
        super(...arguments);
        /**
         * The `name` attribute for the `<input>` for selection.
         * If present, this structured list header row will show its selectable version of the UI.
         */
        this.selectionName = '';
    }
    connectedCallback() {
        if (!this.hasAttribute('role')) {
            this.setAttribute('role', 'row');
        }
        super.connectedCallback();
    }
    render() {
        // We could look up in DOM for `${prefix}-structured-list[hasSelection]`,
        // but uses `hasSelection` prop to utilize attribute change callback
        if (this.selectionName) {
            return html `
        <slot></slot>
        <div class="${prefix}--structured-list-th"></div>
      `;
        }
        return html ` <slot></slot> `;
    }
};
CDSStructuredListHeaderRow.styles = styles;
__decorate([
    property({ attribute: 'selection-name' })
], CDSStructuredListHeaderRow.prototype, "selectionName", void 0);
CDSStructuredListHeaderRow = __decorate([
    carbonElement(`${prefix}-structured-list-header-row`)
], CDSStructuredListHeaderRow);
var CDSStructuredListHeaderRow$1 = CDSStructuredListHeaderRow;

export { CDSStructuredListHeaderRow$1 as default };
//# sourceMappingURL=structured-list-header-row.js.map
