/**
 * Copyright IBM Corp. 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

import { __decorate } from 'tslib';
import { LitElement, html } from 'lit';
import { prefix } from '../../globals/settings.js';
import styles from './tabs.scss.js';
import { carbonElement } from '../../globals/decorators/carbon-element.js';

/**
 * @license
 *
 * Copyright IBM Corp. 2019, 2023
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
/**
 * Skeleton of tab.
 */
let CDSTabSkeleton = class CDSTabSkeleton extends LitElement {
    render() {
        return html ` <div class="${prefix}--tabs__nav-link"></div> `;
    }
};
CDSTabSkeleton.styles = styles;
CDSTabSkeleton = __decorate([
    carbonElement(`${prefix}-tab-skeleton`)
], CDSTabSkeleton);
var CDSTabSkeleton$1 = CDSTabSkeleton;

export { CDSTabSkeleton$1 as default };
//# sourceMappingURL=tab-skeleton.js.map
