/**
 * Copyright IBM Corp. 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

import { __decorate } from 'tslib';
import { html } from 'lit';
import { property } from 'lit/decorators.js';
import { prefix } from '../../globals/settings.js';
import CDSContentSwitcherItem from '../content-switcher/content-switcher-item.js';
import './tabs.js';
import styles from './tabs.scss.js';
import { carbonElement } from '../../globals/decorators/carbon-element.js';
import { TABS_TYPE } from './defs.js';

/**
 * @license
 *
 * Copyright IBM Corp. 2019, 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
/**
 * Basic tab.
 *
 * @element cds-tab
 */
let CDSTab = class CDSTab extends CDSContentSwitcherItem {
    constructor() {
        super(...arguments);
        /**
         * `true` if this tab should be highlighted.
         * If `true`, parent `<cds-tabs>` selects/deselects this tab upon keyboard interaction.
         *
         * @private
         */
        this.highlighted = false;
        /**
         * Tab type.
         */
        this.type = TABS_TYPE.REGULAR;
    }
    /**
     * Handles `slotchange` event.
     */
    _handleSlotChange({ target }) {
        // Retrieve content of the slot to use for aria-label.
        const content = target.assignedNodes();
        this.tabTitle = content[0].textContent;
    }
    connectedCallback() {
        if (!this.hasAttribute('role')) {
            this.setAttribute('role', 'listitem');
        }
        super.connectedCallback();
    }
    render() {
        const { disabled, selected, tabTitle, _handleSlotChange: handleSlotChange, } = this;
        // No `href`/`tabindex` to not to make this `<a>` click-focusable
        return html `
      <a
        class="${prefix}--tabs__nav-link"
        role="tab"
        aria-label="${tabTitle}"
        tabindex="${selected ? 0 : -1}"
        ?disabled="${disabled}"
        aria-selected="${Boolean(selected)}">
        <slot @slotchange="${handleSlotChange}"></slot>
      </a>
    `;
    }
};
CDSTab.styles = styles;
__decorate([
    property({ type: Boolean, reflect: true })
], CDSTab.prototype, "highlighted", void 0);
__decorate([
    property({ reflect: true })
], CDSTab.prototype, "type", void 0);
__decorate([
    property()
], CDSTab.prototype, "tabTitle", void 0);
CDSTab = __decorate([
    carbonElement(`${prefix}-tab`)
], CDSTab);
var CDSTab$1 = CDSTab;

export { CDSTab$1 as default };
//# sourceMappingURL=tab.js.map
