/**
 * Copyright IBM Corp. 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

import { __decorate } from 'tslib';
import { LitElement, html } from 'lit';
import { prefix } from '../../globals/settings.js';
import styles from './tabs.scss.js';
import { carbonElement } from '../../globals/decorators/carbon-element.js';

/**
 * @license
 *
 * Copyright IBM Corp. 2019, 2023
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
/**
 * Skeleton of tabs.
 */
let CDSTabsSkeleton = class CDSTabsSkeleton extends LitElement {
    render() {
        return html `
      <div class="${prefix}--tabs-trigger">
        <span class="${prefix}--tabs-trigger-text"></span>
      </div>
      <ul class="${prefix}--tabs__nav">
        <slot></slot>
      </ul>
    `;
    }
};
CDSTabsSkeleton.styles = styles;
CDSTabsSkeleton = __decorate([
    carbonElement(`${prefix}-tabs-skeleton`)
], CDSTabsSkeleton);
var CDSTabsSkeleton$1 = CDSTabsSkeleton;

export { CDSTabsSkeleton$1 as default };
//# sourceMappingURL=tabs-skeleton.js.map
