/**
 * Copyright IBM Corp. 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

import { action } from '../../../node_modules/@storybook/addon-actions/dist/chunk-D5ZWXAHU.mjs.js';
import '../text-input.js';
import { INPUT_TYPE, INPUT_SIZE } from '../defs.js';
import { FORM_ELEMENT_COLOR_SCHEME } from '../../../globals/shared-enums.js';

/**
 * @license
 *
 * Copyright IBM Corp. 2019, 2023
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
const inputTypes = Object.entries(INPUT_TYPE).reduce((acc, [key, val]) => (Object.assign(Object.assign({}, acc), { [`${key.toLowerCase()}`]: val })), {});
const sizes = {
    [`Small size (${INPUT_SIZE.SMALL})`]: INPUT_SIZE.SMALL,
    [`Medium size (${INPUT_SIZE.MEDIUM})`]: INPUT_SIZE.MEDIUM,
    [`Large size (${INPUT_SIZE.LARGE})`]: INPUT_SIZE.LARGE,
};
const colorSchemes = {
    [`Regular`]: null,
    [`Light (${FORM_ELEMENT_COLOR_SCHEME.LIGHT})`]: FORM_ELEMENT_COLOR_SCHEME.LIGHT,
};
const createProps = ({ boolean, textNonEmpty, select }) => {
    const type = select('Input type (type)', inputTypes, INPUT_TYPE.TEXT);
    return {
        colorScheme: select('Color scheme (color-scheme)', colorSchemes, null),
        disabled: boolean('Disabled (disabled)', false),
        value: textNonEmpty('Input value (value)', ''),
        placeholder: textNonEmpty('Placeholder text (placeholder)', 'Optional placeholder text'),
        invalid: boolean('Invalid (invalid)', false),
        onInput: action('input'),
        showPasswordVisibilityToggle: type === INPUT_TYPE.TEXT || type === INPUT_TYPE.PASSWORD
            ? boolean('Show password visibility toggle (show-password-visibility-toggle)', false)
            : null,
        size: select('Input size (size)', sizes, INPUT_SIZE.MEDIUM),
        type,
    };
};

export { createProps as default };
//# sourceMappingURL=helpers.js.map
