/**
 * Copyright IBM Corp. 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

import { __decorate } from 'tslib';
import { LitElement, html } from 'lit';
import { property } from 'lit/decorators.js';
import { carbonElement } from '../../globals/decorators/carbon-element.js';
import { prefix } from '../../globals/settings.js';
import styles from './text-input.scss.js';

/**
 * @license
 *
 * Copyright IBM Corp. 2019, 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
/**
 * Skeleton of number input.
 */
let CDSTextInputSkeleton = class CDSTextInputSkeleton extends LitElement {
    constructor() {
        super(...arguments);
        /**
         * Specify whether the label should be hidden, or not
         */
        this.hideLabel = false;
    }
    render() {
        const { hideLabel } = this;
        return html `
      ${!hideLabel &&
            html ` <span class="${prefix}--label ${prefix}--skeleton"></span> `}
      <div class="${prefix}--text-input ${prefix}--skeleton"></div>
    `;
    }
};
CDSTextInputSkeleton.styles = styles;
__decorate([
    property({ type: Boolean, reflect: true, attribute: 'hide-label' })
], CDSTextInputSkeleton.prototype, "hideLabel", void 0);
CDSTextInputSkeleton = __decorate([
    carbonElement(`${prefix}-text-input-skeleton`)
], CDSTextInputSkeleton);
var CDSTextInputSkeleton$1 = CDSTextInputSkeleton;

export { CDSTextInputSkeleton$1 as default };
//# sourceMappingURL=text-input-skeleton.js.map
