/**
 * Copyright IBM Corp. 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

import { __decorate } from 'tslib';
import { LitElement, html } from 'lit';
import { prefix } from '../../globals/settings.js';
import styles from './textarea.scss.js';
import { carbonElement } from '../../globals/decorators/carbon-element.js';

/**
 * @license
 *
 * Copyright IBM Corp. 2019, 2023
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
/**
 * Skeleton of text area.
 */
let CDSTextareaSkeleton = class CDSTextareaSkeleton extends LitElement {
    render() {
        return html `
      <span class="${prefix}--label ${prefix}--skeleton"></span>
      <div class="${prefix}--skeleton ${prefix}--text-area"></div>
    `;
    }
};
CDSTextareaSkeleton.styles = styles;
CDSTextareaSkeleton = __decorate([
    carbonElement(`${prefix}-textarea-skeleton`)
], CDSTextareaSkeleton);
var CDSTextareaSkeleton$1 = CDSTextareaSkeleton;

export { CDSTextareaSkeleton$1 as default };
//# sourceMappingURL=textarea-skeleton.js.map
