/**
 * Copyright IBM Corp. 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

import { css } from 'lit';

var styles = css([".cds--assistive-text,.cds--visually-hidden{block-size:1px;border:0;margin:-1px;overflow:hidden;padding:0;position:absolute;clip:rect(0,0,0,0);inline-size:1px;visibility:inherit;white-space:nowrap}@keyframes cds--hide-feedback{0%{opacity:1;visibility:inherit}to{opacity:0;visibility:hidden}}@keyframes cds--show-feedback{0%{opacity:0;visibility:hidden}to{opacity:1;visibility:inherit}}@keyframes cds--skeleton{0%{opacity:.3;transform:scaleX(0);transform-origin:left}20%{opacity:1;transform:scaleX(1);transform-origin:left}28%{transform:scaleX(1);transform-origin:right}51%{transform:scaleX(0);transform-origin:right}58%{transform:scaleX(0);transform-origin:right}82%{transform:scaleX(1);transform-origin:right}83%{transform:scaleX(1);transform-origin:left}96%{transform:scaleX(0);transform-origin:left}to{opacity:.3;transform:scaleX(0);transform-origin:left}}.cds--toggle{display:inline-block;-webkit-user-select:none;-moz-user-select:none;user-select:none}.cds--toggle__label-text{color:var(--cds-text-secondary,#525252);display:block;font-size:var(--cds-label-01-font-size,.75rem);font-weight:var(--cds-label-01-font-weight,400);letter-spacing:var(--cds-label-01-letter-spacing,.32px);line-height:var(--cds-label-01-line-height,1.33333);margin-block-end:1rem}.cds--toggle__button{block-size:1px;border:0;margin:-1px;overflow:hidden;padding:0;position:absolute;clip:rect(0,0,0,0);inline-size:1px;visibility:inherit;white-space:nowrap}.cds--toggle__button:focus{outline:none}.cds--toggle__appearance{align-items:center;-moz-column-gap:.5rem;column-gap:.5rem;cursor:pointer;display:inline-grid;grid-template-columns:max-content max-content}.cds--toggle__switch{background-color:var(--cds-toggle-off,#8d8d8d);block-size:1.5rem;border-radius:.75rem;inline-size:3rem;position:relative;transition:background-color 70ms cubic-bezier(.2,0,1,.9)}.cds--toggle__switch:before{background-color:var(--cds-icon-on-color,#fff);block-size:1.125rem;border-radius:50%;content:\"\";inline-size:1.125rem;inset-block-start:.1875rem;inset-inline-start:.1875rem;position:absolute;transition:transform 70ms cubic-bezier(.2,0,1,.9)}@media screen and (prefers-reduced-motion:reduce){.cds--toggle__switch:before{transition:none}}.cds--toggle:not(.cds--toggle--disabled):active .cds--toggle__switch:after,.cds--toggle__button:focus+.cds--toggle__label .cds--toggle__switch:after{block-size:calc(100% + .375rem);border:2px solid var(--cds-focus,#0f62fe);border-radius:1rem;content:\"\";display:block;inline-size:calc(100% + .375rem);margin-block-start:-.1875rem;margin-inline-start:-.1875rem}.cds--toggle__switch--checked{background-color:var(--cds-support-success,#24a148)}.cds--toggle__switch--checked:before{transform:translateX(1.5rem)}.cds--toggle__text{color:var(--cds-text-primary,#161616);font-size:var(--cds-body-01-font-size,.875rem);font-weight:var(--cds-body-01-font-weight,400);letter-spacing:var(--cds-body-01-letter-spacing,.16px);line-height:var(--cds-body-01-line-height,1.42857)}.cds--toggle__appearance--sm .cds--toggle__switch{block-size:1rem;inline-size:2rem}.cds--toggle__appearance--sm .cds--toggle__switch:before{block-size:.625rem;inline-size:.625rem}.cds--toggle__appearance--sm .cds--toggle__switch--checked:before{transform:translateX(1rem)}.cds--toggle__check{block-size:.3125rem;position:absolute;fill:var(--cds-support-success,#24a148);inline-size:.375rem;inset-block-start:.375rem;inset-inline-end:.3125rem;visibility:hidden}.cds--toggle__switch--checked .cds--toggle__check{visibility:visible}.cds--toggle--disabled .cds--toggle__appearance,:host(cds-toggle[disabled]) .cds--toggle__appearance{cursor:not-allowed}.cds--toggle--disabled .cds--toggle__label-text,.cds--toggle--disabled .cds--toggle__text,:host(cds-toggle[disabled]) .cds--toggle__label-text,:host(cds-toggle[disabled]) .cds--toggle__text{color:var(--cds-text-disabled,hsla(0,0%,9%,.25))}.cds--toggle--disabled .cds--toggle__switch,:host(cds-toggle[disabled]) .cds--toggle__switch{background-color:var(--cds-button-disabled,#c6c6c6)}.cds--toggle--disabled .cds--toggle__switch:before,:host(cds-toggle[disabled]) .cds--toggle__switch:before{background-color:var(--cds-icon-on-color-disabled,#8d8d8d)}.cds--toggle--disabled .cds--toggle__check,:host(cds-toggle[disabled]) .cds--toggle__check{fill:var(--cds-button-disabled,#c6c6c6)}.cds--toggle--readonly .cds--toggle__appearance,:host(cds-toggle[read-only]) .cds--toggle__appearance{cursor:default}.cds--toggle--readonly .cds--toggle__switch,:host(cds-toggle[read-only]) .cds--toggle__switch{background-color:transparent;border:1px solid var(--cds-icon-disabled,hsla(0,0%,9%,.25))}.cds--toggle--readonly .cds--toggle__switch:before,:host(cds-toggle[read-only]) .cds--toggle__switch:before{background-color:var(--cds-text-primary,#161616);inset-block-start:.125rem;inset-inline-start:.125rem}.cds--toggle--readonly .cds--toggle__check,:host(cds-toggle[read-only]) .cds--toggle__check{fill:var(--cds-background,#fff);inset-block-start:.3125rem;inset-inline-end:.25rem}.cds--toggle--readonly .cds--toggle__text,:host(cds-toggle[read-only]) .cds--toggle__text{cursor:text;-webkit-user-select:text;-moz-user-select:text;user-select:text}@media (forced-colors:active),screen and (-ms-high-contrast:active){.cds--toggle__switch,.cds--toggle__switch:before{outline:1px solid transparent}.cds--toggle:not(.cds--toggle--disabled):active .cds--toggle__switch,.cds--toggle__button:focus+.cds--toggle__label .cds--toggle__switch{color:Highlight;outline:1px solid Highlight}}.cds--toggle--skeleton{align-items:center;display:flex}.cds--toggle--skeleton .cds--toggle__skeleton-circle{background:var(--cds-skeleton-background,#e8e8e8);block-size:1.125rem;border-radius:50%;inline-size:1.125rem;overflow:hidden;position:relative}.cds--toggle--skeleton .cds--toggle__skeleton-circle:before{animation:cds--skeleton 3s ease-in-out infinite;background:var(--cds-skeleton-element,#c6c6c6);block-size:100%;content:\"\";inline-size:200%;position:absolute;will-change:transform-origin,transform,opacity}@media (prefers-reduced-motion:reduce){.cds--toggle--skeleton .cds--toggle__skeleton-circle:before{animation:none}}.cds--toggle--skeleton .cds--toggle__skeleton-rectangle{background:var(--cds-skeleton-background,#e8e8e8);block-size:.5rem;border:none;box-shadow:none;inline-size:1.5rem;margin-inline-start:.5rem;padding:0;pointer-events:none;position:relative}.cds--toggle--skeleton .cds--toggle__skeleton-rectangle:active,.cds--toggle--skeleton .cds--toggle__skeleton-rectangle:focus,.cds--toggle--skeleton .cds--toggle__skeleton-rectangle:hover{border:none;cursor:default;outline:none}.cds--toggle--skeleton .cds--toggle__skeleton-rectangle:before{animation:cds--skeleton 3s ease-in-out infinite;background:var(--cds-skeleton-element,#c6c6c6);block-size:100%;content:\"\";inline-size:100%;inset-inline-start:0;position:absolute;will-change:transform-origin,transform,opacity}@media (prefers-reduced-motion:reduce){.cds--toggle--skeleton .cds--toggle__skeleton-rectangle:before{animation:none}}[dir=rtl] .cds--toggle__switch--checked:before{transform:translateX(-1.5rem)}[dir=rtl] .cds--toggle__appearance--sm .cds--toggle__switch--checked:before{transform:translateX(-1rem)}:host(cds-toggle){outline:none}:host(cds-toggle[disabled]) .cds--toggle__appearance{cursor:not-allowed}"]);

export { styles as default };
//# sourceMappingURL=toggle.scss.js.map
