/**
 * Copyright IBM Corp. 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

import { __decorate } from 'tslib';
import { prefix } from '../../globals/settings.js';
import CDSPopoverContent from '../popover/popover-content.js';
import styles from './tooltip.scss.js';
import { carbonElement } from '../../globals/decorators/carbon-element.js';

/**
 * @license
 *
 * Copyright IBM Corp. 2019, 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
/**
 * Tooltip content.
 */
let CDSTooltipContent = class CDSTooltipContent extends CDSPopoverContent {
    connectedCallback() {
        if (!this.hasAttribute('aria-hidden')) {
            this.setAttribute('aria-hidden', 'true');
        }
        if (!this.hasAttribute('role')) {
            this.setAttribute('role', 'tooltip');
        }
        super.connectedCallback();
    }
    updated() {
        var _a, _b;
        (_b = (_a = this.shadowRoot) === null || _a === void 0 ? void 0 : _a.querySelector(`.${prefix}--popover-content`)) === null || _b === void 0 ? void 0 : _b.classList.add(`${prefix}--tooltip-content`);
    }
};
CDSTooltipContent.styles = styles; // `styles` here is a `CSSResult` generated by custom Vite loader
CDSTooltipContent = __decorate([
    carbonElement(`${prefix}-tooltip-content`)
], CDSTooltipContent);
var CDSTooltipContent$1 = CDSTooltipContent;

export { CDSTooltipContent$1 as default };
//# sourceMappingURL=tooltip-content.js.map
