/**
 * Copyright IBM Corp. 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

/**
 * @license
 *
 * Copyright IBM Corp. 2020
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
/**
 * Collapse modes of side nav.
 */
var SIDE_NAV_COLLAPSE_MODE;
(function (SIDE_NAV_COLLAPSE_MODE) {
    /**
     * Fixed mode.
     * In this mode, side nav is non-collapsible.
     */
    SIDE_NAV_COLLAPSE_MODE["FIXED"] = "fixed";
    /**
     * Rail mode.
     * In this mode, side nav can be collapsed to a narrower width ("rail" look) with a toggle button.
     */
    SIDE_NAV_COLLAPSE_MODE["RAIL"] = "rail";
    /**
     * Responsive mode.
     * In this mode, side nav sticks in wider screen, and can be completely collapsed with a toggle button in narrower screen.
     */
    SIDE_NAV_COLLAPSE_MODE["RESPONSIVE"] = "responsive";
})(SIDE_NAV_COLLAPSE_MODE || (SIDE_NAV_COLLAPSE_MODE = {}));
/**
 * The usage purpose of side nav.
 */
var SIDE_NAV_USAGE_MODE;
(function (SIDE_NAV_USAGE_MODE) {
    /**
     * Regular usage.
     */
    SIDE_NAV_USAGE_MODE["REGULAR"] = "";
    /**
     * To represent header nav.
     * In this mode, side nav is hidden when header nav is shown, and side nav is shown then header nav is hidden.
     * This mode can be used only with `SIDE_NAV_COLLAPSE_MODE.REGULAR`.
     */
    SIDE_NAV_USAGE_MODE["HEADER_NAV"] = "header-nav";
})(SIDE_NAV_USAGE_MODE || (SIDE_NAV_USAGE_MODE = {}));

export { SIDE_NAV_COLLAPSE_MODE, SIDE_NAV_USAGE_MODE };
//# sourceMappingURL=defs.js.map
