/**
 * Copyright IBM Corp. 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

import { __decorate } from 'tslib';
import { LitElement } from 'lit';
import { query, property } from 'lit/decorators.js';
import { carbonElement } from '../../globals/decorators/carbon-element.js';
import CDSButton from '../button/button.js';
import HostListener from '../../globals/decorators/host-listener.js';
import styles from './header.scss.js';
import { prefix } from '../../globals/settings.js';
import { BUTTON_TOOLTIP_POSITION } from '../button/defs.js';

/**
 * @license
 *
 * Copyright IBM Corp. 2023, 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
/**
 * Header global action button
 *
 * @element cds-header-global-action
 */
let CDSHeaderGlobalAction = class CDSHeaderGlobalAction extends CDSButton {
    connectedCallback() {
        this.tooltipPosition = BUTTON_TOOLTIP_POSITION.BOTTOM;
        super.connectedCallback();
    }
    _handleClick(event) {
        const { disabled } = this;
        if (disabled) {
            event.stopPropagation();
        }
        else {
            const panel = document.querySelector(`#${this.panelId}`);
            // see if there is related panel for header-global-action button first
            // and then set the expanded attr of it accordingly
            if (panel) {
                const expanded = panel.getAttribute('expanded');
                if (expanded) {
                    panel.removeAttribute('expanded');
                }
                else {
                    panel.setAttribute('expanded', 'true');
                }
                const active = !this.active;
                this.active = active;
            }
        }
    }
    updated() {
        if (this._buttonNode) {
            this._buttonNode.classList.add(`${prefix}--header__action`);
        }
    }
    shouldUpdate(changedProperties) {
        if (changedProperties.has('active')) {
            if (this.active) {
                this._buttonNode.classList.add(`${prefix}--header__action--active`);
                if (this.buttonLabelActive) {
                    this.tooltipText = this.buttonLabelActive;
                }
            }
            else {
                this._buttonNode.classList.remove(`${prefix}--header__action--active`);
                if (this.buttonLabelInactive) {
                    this.tooltipText = this.buttonLabelInactive;
                }
            }
        }
        return true;
    }
};
CDSHeaderGlobalAction.shadowRootOptions = Object.assign(Object.assign({}, LitElement.shadowRootOptions), { delegatesFocus: true });
CDSHeaderGlobalAction.styles = styles; // `styles` here is a `CSSResult` generated by custom Vite loader
__decorate([
    query('button')
], CDSHeaderGlobalAction.prototype, "_buttonNode", void 0);
__decorate([
    property({ type: Boolean, reflect: true })
], CDSHeaderGlobalAction.prototype, "active", void 0);
__decorate([
    property({ type: String, attribute: 'panel-id', reflect: true })
], CDSHeaderGlobalAction.prototype, "panelId", void 0);
__decorate([
    property({ attribute: 'button-label-active' })
], CDSHeaderGlobalAction.prototype, "buttonLabelActive", void 0);
__decorate([
    property({ attribute: 'button-label-inactive' })
], CDSHeaderGlobalAction.prototype, "buttonLabelInactive", void 0);
__decorate([
    HostListener('click', { capture: true })
    // @ts-ignore
], CDSHeaderGlobalAction.prototype, "_handleClick", null);
CDSHeaderGlobalAction = __decorate([
    carbonElement(`${prefix}-header-global-action`)
], CDSHeaderGlobalAction);
var CDSHeaderGlobalAction$1 = CDSHeaderGlobalAction;

export { CDSHeaderGlobalAction$1 as default };
//# sourceMappingURL=header-global-action.js.map
