/**
 * Copyright IBM Corp. 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

import { __decorate } from 'tslib';
import { ifDefined } from 'lit/directives/if-defined.js';
import { LitElement, html } from 'lit';
import { property } from 'lit/decorators.js';
import { prefix } from '../../globals/settings.js';
import FocusMixin from '../../globals/mixins/focus.js';
import styles from './header.scss.js';
import { carbonElement } from '../../globals/decorators/carbon-element.js';

/**
 * @license
 *
 * Copyright IBM Corp. 2019, 2023
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
/**
 * The product name UI in header nav.
 *
 * @element cds-header-name
 * @csspart link The link.
 * @csspart prefix The prefix content.
 */
let CDSHeaderName = class CDSHeaderName extends FocusMixin(LitElement) {
    render() {
        const { href, prefix: namePrefix } = this;
        const namePrefixPart = !namePrefix
            ? undefined
            : html `
          <span part="prefix" class="${prefix}--header__name--prefix"
            >${namePrefix}</span
          >
        `;
        return html `
      <a part="link" class="${prefix}--header__name" href="${ifDefined(href)}"
        >${namePrefixPart}&nbsp;<slot></slot
      ></a>
    `;
    }
};
CDSHeaderName.shadowRootOptions = Object.assign(Object.assign({}, LitElement.shadowRootOptions), { delegatesFocus: true });
CDSHeaderName.styles = styles; // `styles` here is a `CSSResult` generated by custom Vite loader
__decorate([
    property()
], CDSHeaderName.prototype, "href", void 0);
__decorate([
    property()
], CDSHeaderName.prototype, "prefix", void 0);
CDSHeaderName = __decorate([
    carbonElement(`${prefix}-header-name`)
], CDSHeaderName);
var CDSHeaderName$1 = CDSHeaderName;

export { CDSHeaderName$1 as default };
//# sourceMappingURL=header-name.js.map
